/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config.skill;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.config.skill.SkillDefinitionConfig;
import net.puffish.skillsmod.util.DisposeContext;

public class SkillDefinitionsConfig {
    private final Set<String> valid;
    private final Map<String, SkillDefinitionConfig> definitions;

    private SkillDefinitionsConfig(Set<String> valid, Map<String, SkillDefinitionConfig> definitions) {
        this.valid = valid;
        this.definitions = definitions;
    }

    public static Result<SkillDefinitionsConfig, Problem> parse(JsonElement rootElement, ConfigContext context) {
        return rootElement.getAsObject().andThen(rootObject -> SkillDefinitionsConfig.parse(rootObject, context));
    }

    public static Result<SkillDefinitionsConfig, Problem> parse(JsonObject rootObject, ConfigContext context) {
        return rootObject.getAsMap((id, element) -> SkillDefinitionConfig.parse(id, element, context)).mapFailure(problems -> Problem.combine(problems.values())).mapSuccess(map -> new SkillDefinitionsConfig(map.keySet(), map.entrySet().stream().flatMap(entry -> ((Optional)entry.getValue()).map(value -> Map.entry((String)entry.getKey(), value)).stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))));
    }

    public boolean isValid(String id) {
        return this.valid.contains(id);
    }

    public boolean isLoaded(String id) {
        return this.definitions.containsKey(id);
    }

    public Optional<SkillDefinitionConfig> getById(String id) {
        return Optional.ofNullable(this.definitions.get(id));
    }

    public Collection<SkillDefinitionConfig> getAll() {
        return this.definitions.values();
    }

    public void dispose(DisposeContext context) {
        for (SkillDefinitionConfig definition : this.definitions.values()) {
            definition.dispose(context);
        }
    }
}

