/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.impl.json;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import net.puffish.skillsmod.api.json.JsonArray;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonPath;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.impl.json.JsonElementImpl;
import net.puffish.skillsmod.impl.json.JsonObjectTrackingImpl;
import net.puffish.skillsmod.util.JsonPathFailure;

public record JsonObjectImpl(JsonObject json, JsonPath path) implements net.puffish.skillsmod.api.json.JsonObject
{
    @Override
    public Result<JsonElement, Problem> get(String key) {
        JsonPath newPath = this.path.getObject(key);
        com.google.gson.JsonElement element = this.json.get(key);
        if (element == null) {
            return Result.failure(JsonPathFailure.expectedToExist(newPath));
        }
        return Result.success(new JsonElementImpl(element, newPath));
    }

    @Override
    public Result<net.puffish.skillsmod.api.json.JsonObject, Problem> getObject(String key) {
        return this.get(key).mapFailure(e -> JsonPathFailure.expectedToExistAndBe(this.path.getObject(key), "an object")).andThen(JsonElement::getAsObject);
    }

    @Override
    public Result<JsonArray, Problem> getArray(String key) {
        return this.get(key).mapFailure(e -> JsonPathFailure.expectedToExistAndBe(this.path.getObject(key), "an array")).andThen(JsonElement::getAsArray);
    }

    @Override
    public Result<String, Problem> getString(String key) {
        return this.get(key).mapFailure(e -> JsonPathFailure.expectedToExistAndBe(this.path.getObject(key), "a string")).andThen(JsonElement::getAsString);
    }

    @Override
    public Result<Float, Problem> getFloat(String key) {
        return this.get(key).mapFailure(e -> JsonPathFailure.expectedToExistAndBe(this.path.getObject(key), "a float")).andThen(JsonElement::getAsFloat);
    }

    @Override
    public Result<Double, Problem> getDouble(String key) {
        return this.get(key).mapFailure(e -> JsonPathFailure.expectedToExistAndBe(this.path.getObject(key), "a double")).andThen(JsonElement::getAsDouble);
    }

    @Override
    public Result<Integer, Problem> getInt(String key) {
        return this.get(key).mapFailure(e -> JsonPathFailure.expectedToExistAndBe(this.path.getObject(key), "an int")).andThen(JsonElement::getAsInt);
    }

    @Override
    public Result<Boolean, Problem> getBoolean(String key) {
        return this.get(key).mapFailure(e -> JsonPathFailure.expectedToExistAndBe(this.path.getObject(key), "a boolean")).andThen(JsonElement::getAsBoolean);
    }

    @Override
    public Stream<Map.Entry<String, JsonElement>> stream() {
        return this.json.asMap().entrySet().stream().map(entry -> Map.entry((String)entry.getKey(), new JsonElementImpl((com.google.gson.JsonElement)entry.getValue(), this.path.getObject((String)entry.getKey()))));
    }

    @Override
    public JsonElement getAsElement() {
        return new JsonElementImpl((com.google.gson.JsonElement)this.json, this.path);
    }

    @Override
    public <S, F> Result<Map<String, S>, Map<String, F>> getAsMap(BiFunction<String, JsonElement, Result<S, F>> function) {
        HashMap successes = new HashMap();
        HashMap failures = new HashMap();
        this.json.asMap().forEach((key, value) -> ((Result)function.apply((String)key, new JsonElementImpl((com.google.gson.JsonElement)value, this.path.getObject((String)key)))).ifSuccess(t -> successes.put(key, t)).ifFailure(t -> failures.put(key, t)));
        if (failures.isEmpty()) {
            return Result.success(successes);
        }
        return Result.failure(failures);
    }

    @Override
    public <S> Result<S, Problem> noUnused(Function<net.puffish.skillsmod.api.json.JsonObject, Result<S, Problem>> function) {
        JsonObjectTrackingImpl tracking = new JsonObjectTrackingImpl(this);
        Result<S, Problem> result = function.apply(tracking);
        List<Problem> problems = tracking.reportUnusedEntries();
        if (problems.isEmpty()) {
            return result;
        }
        problems = new ArrayList<Problem>(problems);
        result.ifFailure(problems::add);
        return Result.failure(Problem.combine(problems));
    }

    @Override
    public JsonObject getJson() {
        return this.json;
    }

    @Override
    public JsonPath getPath() {
        return this.path;
    }
}

