/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranim.lib.mochafloats.parser.ast;

import com.zigythebird.playeranim.lib.mochafloats.parser.ast.Expression;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.ExpressionVisitor;
import com.zigythebird.playeranim.lib.mochafloats.util.ExprBytesUtils;
import com.zigythebird.playeranim.lib.mochafloats.util.ExpressionListUtils;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class CallExpression
implements Expression {
    private final List<Expression> arguments;
    private Expression function;

    public CallExpression(ByteBuf buf) {
        this(ExprBytesUtils.readExpression(buf), ExprBytesUtils.readExpressions(buf));
    }

    public CallExpression(@NotNull Expression function, @NotNull List<Expression> arguments) {
        this.function = Objects.requireNonNull(function, "function");
        this.arguments = Objects.requireNonNull(arguments, "arguments");
    }

    @NotNull
    public Expression function() {
        return this.function;
    }

    public void function(@NotNull Expression function) {
        this.function = Objects.requireNonNull(function, "function");
    }

    @NotNull
    public List<Expression> arguments() {
        return this.arguments;
    }

    @Override
    public <R> R visit(@NotNull ExpressionVisitor<R> visitor) {
        return visitor.visitCall(this);
    }

    @Override
    public void write(ByteBuf buf) {
        ExprBytesUtils.writeExpression(this.function(), buf);
        ExprBytesUtils.writeExpressions(this.arguments(), buf);
    }

    public String toString() {
        return String.format("%s(%s)", this.function, ExpressionListUtils.toString(this.arguments, ","));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CallExpression that = (CallExpression)o;
        if (!this.function.equals(that.function)) {
            return false;
        }
        return this.arguments.equals(that.arguments);
    }

    public int hashCode() {
        int result = this.function.hashCode();
        result = 31 * result + this.arguments.hashCode();
        return result;
    }
}

