/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranim.lib.mochafloats.runtime;

import com.zigythebird.playeranim.lib.mochafloats.parser.ast.BinaryExpression;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.CallExpression;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.Expression;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.ExpressionVisitor;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.FloatExpression;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.TernaryConditionalExpression;
import com.zigythebird.playeranim.lib.mochafloats.runtime.ExpressionInterpreter;
import com.zigythebird.playeranim.lib.mochafloats.runtime.IsConstantExpression;
import com.zigythebird.playeranim.lib.mochafloats.runtime.Scope;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

final class ExpressionInliner
implements ExpressionVisitor<Expression> {
    private final ExpressionInterpreter<?> interpreter;
    private final Scope scope;

    ExpressionInliner(@NotNull ExpressionInterpreter<?> interpreter, @NotNull Scope scope) {
        this.interpreter = Objects.requireNonNull(interpreter, "interpreter");
        this.scope = Objects.requireNonNull(scope, "scope");
    }

    @Override
    @NotNull
    public Expression visitBinary(@NotNull BinaryExpression expression) {
        if (IsConstantExpression.test(expression, this.scope)) {
            return FloatExpression.of(expression.visit(this.interpreter).getAsNumber());
        }
        return expression;
    }

    @Override
    @NotNull
    public Expression visitTernaryConditional(@NotNull TernaryConditionalExpression expression) {
        Expression conditionExpr = expression.condition();
        Expression trueExpr = expression.trueExpression();
        Expression falseExpr = expression.falseExpression();
        if (IsConstantExpression.test(conditionExpr, this.scope)) {
            boolean condition = conditionExpr.visit(this.interpreter).getAsBoolean();
            Expression resultExpr = condition ? trueExpr : falseExpr;
            return resultExpr.visit(this);
        }
        return expression;
    }

    @Override
    @NotNull
    public Expression visitCall(@NotNull CallExpression expression) {
        if (IsConstantExpression.test(expression, this.scope)) {
            return FloatExpression.of(expression.visit(this.interpreter).getAsNumber());
        }
        return expression;
    }

    @Override
    @NotNull
    public Expression visit(@NotNull Expression expression) {
        return expression;
    }
}

