/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.DogSleepOnManager;
import doggytalents.mixin.CameraMixinAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import org.joml.Quaternionfc;

public class DTNClientDogSleepOnManager {
    public static final DTNClientDogSleepOnManager INSTANCE = new DTNClientDogSleepOnManager();
    private final Map<UUID, Dog> sleeperMap = Maps.newHashMap();
    private final List<UUID> toRemove = new ArrayList<UUID>();

    public static DTNClientDogSleepOnManager get() {
        return INSTANCE;
    }

    private DTNClientDogSleepOnManager() {
    }

    @SubscribeEvent
    public void tickClient(ClientTickEvent.Post event) {
        this.invalidateSleeperCache();
    }

    @SubscribeEvent
    public void onPlayerLoggingOut(ClientPlayerNetworkEvent.LoggingOut event) {
        this.sleeperMap.clear();
    }

    public void invalidateSleeperCache() {
        if (this.sleeperMap.isEmpty()) {
            return;
        }
        for (Map.Entry<UUID, Dog> entry : this.sleeperMap.entrySet()) {
            Dog dog = entry.getValue();
            if (dog.isAlive()) continue;
            this.toRemove.add(entry.getKey());
        }
        if (this.toRemove.isEmpty()) {
            return;
        }
        for (UUID player : this.toRemove) {
            this.sleeperMap.remove(player);
        }
        this.toRemove.clear();
    }

    public void onDogSleepOnDataUpdated(Dog dog, DogSleepOnManager.DogSleepOnState state) {
        if (!state.is_sleeping()) {
            this.clearPlayerSleepOnFor(dog);
            return;
        }
        this.sleeperMap.putIfAbsent(state.sleeper(), dog);
        Optional<Player> sleeper_optional = DogSleepOnManager.getSleeperFromDog(dog, state);
        if (!sleeper_optional.isPresent()) {
            return;
        }
        Player sleeper = sleeper_optional.get();
        if (sleeper == Minecraft.getInstance().player) {
            DogSleepOnManager.rotatePlayerYRotToDog(dog, sleeper, state.sleep_yrot());
        }
    }

    public void clearPlayerSleepOnFor(Dog dog) {
        if (this.sleeperMap.isEmpty()) {
            return;
        }
        ArrayList<UUID> toRemove = new ArrayList<UUID>();
        for (Map.Entry<UUID, Dog> entry : this.sleeperMap.entrySet()) {
            if (entry.getValue() != dog) continue;
            toRemove.add(entry.getKey());
        }
        for (UUID key : toRemove) {
            this.sleeperMap.remove(key);
        }
    }

    public boolean onLivingModelSetupRotation(LivingEntity living, PoseStack stack, float yrot, float scale) {
        Optional<Player> player_optional = this.checkIsSleepingOnDog((Entity)living);
        if (!player_optional.isPresent()) {
            return false;
        }
        Player player = player_optional.get();
        float facing = player.getYRot() - 180.0f;
        Vec3 translate = this.calclateSleepTranslate(player);
        stack.translate(translate.x, 0.0, translate.z);
        stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f - facing));
        stack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
        return true;
    }

    private Vec3 calclateSleepTranslate(Player player) {
        UUID uuid = player.getUUID();
        Dog dog = this.sleeperMap.get(uuid);
        if (dog == null) {
            return Vec3.ZERO;
        }
        Vec3 view_vec = player.getViewVector(1.0f);
        float translate_amount = player.getEyeHeight(Pose.STANDING) - 0.1f;
        return view_vec.normalize().scale((double)(-translate_amount));
    }

    public void afterPlayerModelSetupAnim(LivingEntity living, PlayerRenderState state, PlayerModel model) {
        Optional<Player> player_optional = this.checkIsSleepingOnDog((Entity)living);
        if (!player_optional.isPresent()) {
            return;
        }
        model.head.xRot += 0.6981317f;
    }

    private Optional<Player> checkIsSleepingOnDog(Entity entity) {
        if (!entity.hasPose(Pose.SLEEPING)) {
            return Optional.empty();
        }
        if (this.sleeperMap.isEmpty()) {
            return Optional.empty();
        }
        if (!(entity instanceof Player)) {
            return Optional.empty();
        }
        Player player = (Player)entity;
        Dog sleep_on = this.sleeperMap.get(player.getUUID());
        if (sleep_on == null) {
            return Optional.empty();
        }
        return Optional.of(player);
    }

    public void afterCameraSetup(Camera camera, Entity entity) {
        if (this.sleeperMap.isEmpty()) {
            return;
        }
        Optional<Player> player_optional = this.checkIsSleepingOnDog(entity);
        if (!player_optional.isPresent()) {
            return;
        }
        Player player = player_optional.get();
        Dog dog = this.sleeperMap.get(player.getUUID());
        ((CameraMixinAccessor)camera).dtn__setRotation(dog.getSleepOnState().sleep_yrot(), 0.0f);
    }
}

