/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.block.model;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import doggytalents.api.registry.IBeddingMaterial;
import doggytalents.api.registry.ICasingMaterial;
import doggytalents.client.block.model.DogBedItemOverride;
import doggytalents.common.block.DogBedMaterialManager;
import doggytalents.common.block.tileentity.DogBedTileEntity;
import doggytalents.common.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.SimpleModelWrapper;
import net.minecraft.client.renderer.block.model.SimpleUnbakedGeometry;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelDebugName;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.client.resources.model.SpriteGetter;
import net.minecraft.client.resources.model.UnbakedGeometry;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.model.data.ModelData;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;

@OnlyIn(value=Dist.CLIENT)
public class DogBedModel
implements BlockStateModel {
    public static DogBedItemOverride ITEM_OVERIDE = new DogBedItemOverride();
    private static final ResourceLocation MISSING_TEXTURE = Util.getVanillaResource("missingno");
    private final ModelBakery modelLoader;
    private final BlockModel unbakedModel;
    private final BlockStateModel defaultModelVariant;
    private final Map<Direction, SimpleModelWrapper> defaultModelVariants = new ConcurrentHashMap<Direction, SimpleModelWrapper>(Direction.values().length);
    private final Map<Direction, SimpleModelWrapper> missingModelVariant = new ConcurrentHashMap<Direction, SimpleModelWrapper>(Direction.values().length);
    private static final Map<Triple<ICasingMaterial, IBeddingMaterial, Direction>, SimpleModelWrapper> cache = Maps.newConcurrentMap();
    private final int maxCacheSize;

    public DogBedModel(ModelBakery modelLoader, BlockModel model, BlockStateModel defaultModelVariant, int maxCacheSize) {
        this.modelLoader = modelLoader;
        this.unbakedModel = model;
        this.defaultModelVariant = defaultModelVariant;
        this.maxCacheSize = maxCacheSize;
    }

    public static void clearCache() {
        cache.clear();
    }

    public SimpleModelWrapper getModelVariant(@Nonnull ModelData data) {
        return this.getModelVariant((ICasingMaterial)data.get(DogBedTileEntity.CASING), (IBeddingMaterial)data.get(DogBedTileEntity.BEDDING), (Direction)data.get(DogBedTileEntity.FACING));
    }

    public SimpleModelWrapper getModelVariant(ICasingMaterial casing, IBeddingMaterial bedding, Direction facing) {
        if (facing == null) {
            facing = Direction.NORTH;
        }
        if (casing == null || bedding == null) {
            return this.getDefaultVariant(facing);
        }
        if (casing.isNani() || bedding.isNani()) {
            return this.getMissingVariant(facing);
        }
        ImmutableTriple key = ImmutableTriple.of((Object)casing, (Object)bedding, (Object)facing);
        SimpleModelWrapper model_variant = cache.get(key);
        if (model_variant != null) {
            return model_variant;
        }
        if (cache.size() >= this.maxCacheSize) {
            return this.getDefaultVariant(facing);
        }
        model_variant = this.bakeModelVariant(casing, bedding, facing);
        cache.put((Triple<ICasingMaterial, IBeddingMaterial, Direction>)key, model_variant);
        return model_variant;
    }

    private SimpleModelWrapper getMissingVariant(Direction dir) {
        SimpleModelWrapper missing = this.missingModelVariant.get(dir);
        if (missing != null) {
            return missing;
        }
        missing = this.bakeModelVariant(DogBedMaterialManager.NaniCasing.NULL, DogBedMaterialManager.NaniBedding.NULL, dir);
        this.missingModelVariant.put(dir, missing);
        return missing;
    }

    private SimpleModelWrapper getDefaultVariant(Direction dir) {
        SimpleModelWrapper default_variant = this.defaultModelVariants.get(dir);
        if (default_variant != null) {
            return default_variant;
        }
        default_variant = DogBedModel.bakeModel(this.unbakedModel, dir);
        this.defaultModelVariants.put(dir, default_variant);
        return default_variant;
    }

    public TextureAtlasSprite getParticleIcon(@Nonnull ModelData data) {
        return this.getModelVariant(data).particleIcon();
    }

    public SimpleModelWrapper bakeModelVariant(@Nullable ICasingMaterial casing, @Nullable IBeddingMaterial bedding, @Nonnull Direction facing) {
        BlockModel new_model = this.prepareVariantBlockModelForBaking_1_21_5(this.unbakedModel, casing, bedding);
        SimpleModelWrapper ret = DogBedModel.bakeModel(new_model, facing);
        return ret;
    }

    private static SimpleModelWrapper bakeModel(BlockModel to_bake, Direction dir) {
        return DogBedModel.bakeModel_1_21_5(to_bake, dir);
    }

    private static BlockModelRotation getModelRotation(@Nonnull Direction dir) {
        switch (dir) {
            default: {
                return BlockModelRotation.X0_Y0;
            }
            case EAST: {
                return BlockModelRotation.X0_Y90;
            }
            case SOUTH: {
                return BlockModelRotation.X0_Y180;
            }
            case WEST: 
        }
        return BlockModelRotation.X0_Y270;
    }

    private static Either<Material, String> findCasingTexture(@Nullable ICasingMaterial resource) {
        return DogBedModel.findTexture(resource != null ? resource.getTexture() : null);
    }

    private static Either<Material, String> findBeddingTexture(@Nullable IBeddingMaterial resource) {
        return DogBedModel.findTexture(resource != null ? resource.getTexture() : null);
    }

    private static Either<Material, String> findTexture(ResourceLocation resource) {
        if (resource == null) {
            resource = MISSING_TEXTURE;
        }
        return Either.left((Object)new Material(TextureAtlas.LOCATION_BLOCKS, resource));
    }

    public TextureAtlasSprite particleIcon() {
        return this.defaultModelVariant.particleIcon();
    }

    public void collectParts(BlockAndTintGetter level, BlockPos pos, BlockState state, RandomSource random, List<BlockModelPart> parts) {
        ModelData model_data = level.getModelData(pos);
        SimpleModelWrapper part = this.getModelVariant(model_data);
        if (part != null) {
            parts.add((BlockModelPart)part);
        }
    }

    public void collectParts(RandomSource random, List<BlockModelPart> parts) {
        SimpleModelWrapper part = this.getModelVariant(null, null, Direction.NORTH);
        if (part != null) {
            parts.add((BlockModelPart)part);
        }
    }

    public TextureAtlasSprite particleIcon(BlockAndTintGetter level, BlockPos pos, BlockState state) {
        ModelData model_data = level.getModelData(pos);
        return this.getParticleIcon(model_data);
    }

    private static List<BlockElement> getElements_1_21_5(BlockModel model) {
        UnbakedGeometry unbakedGeometry = model.geometry();
        if (!(unbakedGeometry instanceof SimpleUnbakedGeometry)) {
            return List.of();
        }
        SimpleUnbakedGeometry element_getter = (SimpleUnbakedGeometry)unbakedGeometry;
        return element_getter.elements();
    }

    private BlockModel prepareVariantBlockModelForBaking_1_21_5(BlockModel model, @Nullable ICasingMaterial casing, @Nullable IBeddingMaterial bedding) {
        List<BlockElement> elements_old = DogBedModel.getElements_1_21_5(model);
        ArrayList<BlockElement> elements_new = new ArrayList<BlockElement>(elements_old.size());
        for (BlockElement element : elements_old) {
            BlockElement element_copy = new BlockElement(element.from(), element.to(), (Map)Maps.newHashMap((Map)element.faces()), element.rotation(), element.shade(), element.lightEmission());
            elements_new.add(element_copy);
        }
        Either<Material, String> casing_texture = DogBedModel.findCasingTexture(casing);
        Either<Material, String> bedding_texture = DogBedModel.findBeddingTexture(bedding);
        TextureSlots.Data.Builder builder = new TextureSlots.Data.Builder();
        DogBedModel.addMaterialToBuilder_1_21_5(builder, "bedding", bedding_texture);
        DogBedModel.addMaterialToBuilder_1_21_5(builder, "casing", casing_texture);
        DogBedModel.addMaterialToBuilder_1_21_5(builder, "particle", casing_texture);
        TextureSlots.Data texture_map = builder.build();
        BlockModel ret = new BlockModel((UnbakedGeometry)new SimpleUnbakedGeometry(elements_new), model.guiLight(), model.ambientOcclusion(), model.transforms(), texture_map, model.parent(), model.rootTransform(), model.renderTypeGroup(), new HashMap(model.partVisibility()));
        return ret;
    }

    private static void addMaterialToBuilder_1_21_5(TextureSlots.Data.Builder builder, String name, Either<Material, String> material) {
        if (material.left().isPresent()) {
            builder.addTexture(name, (Material)material.left().get());
            return;
        }
        if (material.right().isPresent()) {
            builder.addReference(name, (String)material.right().get());
            return;
        }
    }

    private static SimpleModelWrapper bakeModel_1_21_5(BlockModel model, Direction dir) {
        ResolvedModel resolved_model = DogBedModel.resolvedModel_1_21_5((UnbakedModel)model);
        ModelBaker baker = DogBedModel.modelBaker_1_21_5(resolved_model);
        return SimpleModelWrapper.bake((ModelBaker)baker, (ResolvedModel)resolved_model, (ModelState)DogBedModel.getModelRotation(dir));
    }

    public static ResolvedModel resolvedModel_1_21_5(final UnbakedModel model) {
        return new ResolvedModel(){

            public String debugName() {
                return "DTN Dog Bed Variant Model";
            }

            public UnbakedModel wrapped() {
                return model;
            }

            @Nullable
            public ResolvedModel parent() {
                return null;
            }
        };
    }

    public static ModelBaker modelBaker_1_21_5(final ResolvedModel resolved_model) {
        return new ModelBaker(){

            public ResolvedModel getModel(ResourceLocation p_405736_) {
                return resolved_model;
            }

            public SpriteGetter sprites() {
                return new SpriteGetter(this){

                    public TextureAtlasSprite get(Material material, ModelDebugName p_404904_) {
                        return material.sprite();
                    }

                    public TextureAtlasSprite reportMissingReference(String p_387031_, ModelDebugName p_405621_) {
                        return new Material(TextureAtlas.LOCATION_BLOCKS, MissingTextureAtlasSprite.getLocation()).sprite();
                    }
                };
            }

            public <T> T compute(ModelBaker.SharedOperationKey<T> p_410340_) {
                return (T)p_410340_.compute((ModelBaker)this);
            }
        };
    }
}

