/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import doggytalents.client.entity.model.AnimatedSyncedAccessoryModel;
import doggytalents.client.entity.model.animation.DogKeyframeAnimations;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.Util;
import net.minecraft.client.animation.AnimationChannel;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.animation.KeyframeAnimations;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import org.joml.Vector3f;

public class TorchDogModel
extends AnimatedSyncedAccessoryModel {
    public ModelPart torchBig;
    public ModelPart torchSmall2;
    public ModelPart torchSmall;
    private Vector3f vecObj = new Vector3f(0.0f, 0.0f, 0.0f);
    public static final AnimationDefinition TORCH_SPINNA = AnimationDefinition.Builder.withLength((float)3.0f).looping().addAnimation("torch_small", new AnimationChannel(AnimationChannel.Targets.POSITION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.posVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(1.5f, KeyframeAnimations.posVec((float)0.0f, (float)-5.0f, (float)9.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(3.0f, KeyframeAnimations.posVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("torch_small", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(1.5f, KeyframeAnimations.degreeVec((float)0.0f, (float)180.0f, (float)-30.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(3.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)360.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("torch_small2", new AnimationChannel(AnimationChannel.Targets.POSITION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.posVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(1.0416766f, KeyframeAnimations.posVec((float)0.0f, (float)-1.0f, (float)4.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(3.0f, KeyframeAnimations.posVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("torch_small2", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(1.5f, KeyframeAnimations.degreeVec((float)0.0f, (float)180.0f, (float)25.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(3.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)360.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("torch_big", new AnimationChannel(AnimationChannel.Targets.POSITION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.posVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(1.5f, KeyframeAnimations.posVec((float)0.0f, (float)2.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(3.0f, KeyframeAnimations.posVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM)})).build();

    public TorchDogModel(ModelPart box) {
        super(box);
        this.torchBig = this.root.getChild("torch_big");
        this.torchSmall = this.root.getChild("torch_small");
        this.torchSmall2 = this.root.getChild("torch_small2");
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition torch_big = partdefinition.addOrReplaceChild("torch_big", CubeListBuilder.create().texOffs(4, 7).addBox(-1.0f, -2.5f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(-0.4f)), PartPose.offset((float)0.25f, (float)5.5f, (float)-4.0f));
        PartDefinition torch_small2 = partdefinition.addOrReplaceChild("torch_small2", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)7.0f, (float)-4.0f));
        PartDefinition cube_r1 = torch_small2.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(4, 7).mirror().addBox(-9.0f, -4.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(-0.6f)).mirror(false).texOffs(4, 7).addBox(7.0f, -4.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(-0.6f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition torch_small = partdefinition.addOrReplaceChild("torch_small", CubeListBuilder.create().texOffs(4, 7).addBox(7.0f, -2.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(-0.6f)).texOffs(4, 7).mirror().addBox(-9.0f, -2.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(-0.6f)).mirror(false), PartPose.offset((float)0.0f, (float)5.0f, (float)-4.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)16, (int)16);
    }

    public void prepareModel(Dog dog) {
        this.root.visible = dog.isDoingFine();
    }

    @Override
    public void setupAnim(Dog entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        long animLenMillis = (long)TORCH_SPINNA.lengthInSeconds() * 1000L;
        double offset = (double)(entityIn.getId() % 6) * 10.0;
        double timeLine = (offset + (double)((entityIn.isDefeated() ? 0.25f : 1.0f) * ageInTicks)) % Util.millisToTickMayWithPartial(animLenMillis);
        long timeLineMillis = Util.tickMayWithPartialToMillis(timeLine);
        if (entityIn.getId() % 2 == 0) {
            timeLineMillis = animLenMillis - timeLineMillis;
        }
        DogKeyframeAnimations.animate(this, entityIn, TORCH_SPINNA, timeLineMillis, 1.0f, this.vecObj);
    }

    @Override
    public void renderToBuffer(PoseStack p_102034_, VertexConsumer p_102035_, int p_102036_, int p_102037_, int color_overlay) {
        super.renderToBuffer(p_102034_, p_102035_, 0xF000F0, p_102037_, color_overlay);
    }

    @Override
    public void resetAllPose() {
        this.root.resetPose();
        this.torchBig.resetPose();
        this.torchSmall.resetPose();
        this.torchSmall2.resetPose();
    }

    @Override
    protected void populatePart(ModelPart box) {
    }
}

