/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.model.animation;

import doggytalents.client.entity.model.AnimatedSyncedAccessoryModel;
import doggytalents.client.entity.model.animation.SimpleAnimatedModel;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.common.entity.Dog;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.animation.AnimationChannel;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.function.Consumers;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class DogKeyframeAnimations {
    public static void animate(DogModel model, Dog dog, AnimationDefinition animation, long elapsed_in_millis, float interpolation_scale, Vector3f temp_buffer) {
        DogKeyframeAnimations.keyframeAnimate(AnimationContext.of(model::searchForPartWithName, part -> model.resetPart((ModelPart)part, dog), part -> model.adjustAnimatedPart((ModelPart)part, dog)), animation, elapsed_in_millis, interpolation_scale, temp_buffer);
    }

    public static void animate(AnimatedSyncedAccessoryModel model, Dog dog, AnimationDefinition animation, long elapsed_in_millis, float interpolation_scale, Vector3f temp_buffer) {
        DogKeyframeAnimations.keyframeAnimate(AnimationContext.of(model::searchForPartWithName, part -> model.resetPart((ModelPart)part, dog)), animation, elapsed_in_millis, interpolation_scale, temp_buffer);
    }

    public static void animateSimple(SimpleAnimatedModel model, AnimationDefinition animation, long elapsed_in_millis, float interpolation_scale, Vector3f temp_buffer) {
        DogKeyframeAnimations.keyframeAnimate(AnimationContext.of(model::getPartFromName, model::resetPart), animation, elapsed_in_millis, interpolation_scale, temp_buffer);
    }

    public static float getCurrentAnimatedYRot(Dog dog, AnimationDefinition animation, long elapsed_in_millis, float swing) {
        float elapsed_in_seconds = DogKeyframeAnimations.getElapsedSeconds(animation, elapsed_in_millis);
        List rootChannelList = (List)animation.boneAnimations().get("root");
        if (rootChannelList == null || rootChannelList.isEmpty()) {
            return 0.0f;
        }
        AnimationChannel rotationChannel = null;
        for (AnimationChannel channel : rootChannelList) {
            if (channel.target() != AnimationChannel.Targets.ROTATION) continue;
            rotationChannel = channel;
        }
        if (rotationChannel == null) {
            return 0.0f;
        }
        Vector3f result = new Vector3f(0.0f, 0.0f, 0.0f);
        DogKeyframeAnimations.getAnimationValueForChannel(result, rotationChannel, elapsed_in_seconds, swing);
        return result.y;
    }

    public static void keyframeAnimate(AnimationContext context, AnimationDefinition animation, long elapsed_in_millis, float swing, Vector3f buffer) {
        float elapsed_in_seconds = DogKeyframeAnimations.getElapsedSeconds(animation, elapsed_in_millis);
        for (Map.Entry entry : animation.boneAnimations().entrySet()) {
            Optional<ModelPart> partOptional = context.getPart((String)entry.getKey());
            if (partOptional.isEmpty()) continue;
            ModelPart part = partOptional.get();
            context.resetPart(part);
            List channelList = (List)entry.getValue();
            for (AnimationChannel channel : channelList) {
                DogKeyframeAnimations.getAnimationValueForChannel(buffer, channel, elapsed_in_seconds, swing);
                channel.target().apply(part, buffer);
                context.adjustAnimatedPart(part);
            }
        }
    }

    public static void getAnimationValueForChannel(Vector3f buffer, AnimationChannel channel, float elapsed_seconds, float swing) {
        Keyframe[] keyframes = channel.keyframes();
        if (keyframes.length <= 0) {
            return;
        }
        int kf_indx_now = Mth.binarySearch((int)0, (int)keyframes.length, compare_indx -> elapsed_seconds <= keyframes[compare_indx].timestamp()) - 1;
        kf_indx_now = Mth.clamp((int)kf_indx_now, (int)0, (int)(keyframes.length - 1));
        int kf_indx_next = Mth.clamp((int)(kf_indx_now + 1), (int)0, (int)(keyframes.length - 1));
        Keyframe kf_now = keyframes[kf_indx_now];
        Keyframe kf_next = keyframes[kf_indx_next];
        float time_between = kf_next.timestamp() - kf_now.timestamp();
        float t_since_kf_now = elapsed_seconds - kf_now.timestamp();
        float progress = 0.0f;
        if (time_between > 0.0f) {
            progress = Mth.clamp((float)(t_since_kf_now / time_between), (float)0.0f, (float)1.0f);
        }
        kf_next.interpolation().apply(buffer, progress, keyframes, kf_indx_now, kf_indx_next, swing);
    }

    public static float getElapsedSeconds(AnimationDefinition animation, long raw_millis) {
        float f = (float)raw_millis / 1000.0f;
        return animation.looping() ? f % animation.lengthInSeconds() : f;
    }

    public static Optional<ModelPart> searchForPartWithName(ModelPart root, String name) {
        return DogKeyframeAnimations.searchForPartWithName(root, name, true);
    }

    public static Optional<ModelPart> searchForPartWithName(ModelPart root, String name, boolean check_root) {
        if (root.hasChild(name)) {
            return Optional.of(root.getChild(name));
        }
        if (check_root && name.equals("root")) {
            return Optional.of(root);
        }
        Optional<ModelPart> partOptional = root.getAllParts().stream().filter(part -> part.hasChild(name)).findFirst();
        return partOptional.map(part -> part.getChild(name));
    }

    public static interface AnimationContext {
        public static AnimationContext of(Function<String, Optional<ModelPart>> partGetter, Consumer<ModelPart> partReset) {
            return AnimationContext.of(partGetter, partReset, Consumers.nop());
        }

        public static AnimationContext of(final Function<String, Optional<ModelPart>> partGetter, final Consumer<ModelPart> partReset, final Consumer<ModelPart> partAdjust) {
            return new AnimationContext(){

                @Override
                public Optional<ModelPart> getPart(String name) {
                    return (Optional)partGetter.apply(name);
                }

                @Override
                public void resetPart(ModelPart part) {
                    partReset.accept(part);
                }

                @Override
                public void adjustAnimatedPart(ModelPart part) {
                    partAdjust.accept(part);
                }
            };
        }

        public Optional<ModelPart> getPart(String var1);

        public void resetPart(ModelPart var1);

        public void adjustAnimatedPart(ModelPart var1);
    }
}

