/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import doggytalents.api.backward_imitate.ItemUtil_1_21_5;
import doggytalents.client.ClientSetup;
import doggytalents.client.backward_imitate.DogRenderLayerWithRenderState_21_3;
import doggytalents.client.backward_imitate.DogRenderState_21_3;
import doggytalents.client.entity.model.SyncedRenderFunctionWithHeadModel;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.client.entity.skin.DogSkin;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.joml.Quaternionfc;

public class DogMouthItemRenderer
extends DogRenderLayerWithRenderState_21_3 {
    private ItemRenderer itemInHandRenderer;
    private SyncedRenderFunctionWithHeadModel itemSyncer;
    private ItemModelResolver itemModelResolver_1_21_5;
    private final ItemStackRenderState mouthItemRenderState_1_21_5 = new ItemStackRenderState();

    public DogMouthItemRenderer(RenderLayerParent dogRendererIn, EntityRendererProvider.Context ctx) {
        super((RenderLayerParent<DogRenderState_21_3, DogModel>)dogRendererIn);
        this.itemInHandRenderer = Minecraft.getInstance().getItemRenderer();
        this.itemSyncer = new SyncedRenderFunctionWithHeadModel(ctx.bakeLayer(ClientSetup.DOG_SYNCED_FUNCTION_WITH_HEAD));
        this.init_1_21_5(ctx);
    }

    @Override
    public void render(PoseStack matrixStack, MultiBufferSource bufferSource, int packedLight, Dog dog, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, DogRenderState_21_3 render_state) {
        DogModel model;
        DogSkin skin;
        if (!((Boolean)ConfigHandler.CLIENT.MOUTH_ITEM_FORCE_RENDER.get()).booleanValue() && (skin = dog.getClientSkin()).useCustomModel() && !(model = skin.getCustomModel().getValue()).armorShouldRender(dog)) {
            return;
        }
        Optional<ItemStack> stackOptional = dog.getMouthItemForRender();
        if (!stackOptional.isPresent()) {
            return;
        }
        ItemStack stack = stackOptional.get();
        DogModel model2 = (DogModel)this.getParentModel();
        model2.copyPropertiesTo(this.itemSyncer);
        this.itemSyncer.sync(model2);
        this.itemSyncer.startRenderFromRoot(matrixStack, matrixStack1 -> this.renderItem(matrixStack1, bufferSource, packedLight, dog, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, stack, render_state));
    }

    public void renderItem(PoseStack stack, MultiBufferSource bufferSource, int packedLight, Dog dog, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, ItemStack itemStack, DogRenderState_21_3 render_state) {
        stack.pushPose();
        stack.translate(-0.025f, 0.125f, -0.32f);
        Item item = itemStack.getItem();
        if (ItemUtil_1_21_5.isMeleeWeapon(itemStack) || ItemUtil_1_21_5.isDiggerItem(itemStack) || itemStack.is(Items.TRIDENT)) {
            stack.translate(0.25, 0.0, 0.0);
        }
        if (item instanceof BowItem || item instanceof CrossbowItem) {
            stack.scale(1.0f, -1.0f, -1.0f);
            stack.translate(0.0, 0.0, -0.1);
        }
        if (item instanceof BlockItem) {
            stack.scale(0.5f, -0.5f, -0.5f);
            stack.translate(0.2f, -0.31f, 0.07f);
            stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(60.0f));
        } else {
            stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(45.0f));
            stack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
        }
        this.updateAndRenderItem_1_21_5(dog, itemStack, stack, bufferSource, packedLight);
        stack.popPose();
    }

    private void init_1_21_5(EntityRendererProvider.Context ctx) {
        this.itemModelResolver_1_21_5 = ctx.getItemModelResolver();
    }

    private void updateMouthItemRenderState_1_21_5(Dog dog, ItemStack mouth_item) {
        this.itemModelResolver_1_21_5.updateForLiving(this.mouthItemRenderState_1_21_5, mouth_item, ItemDisplayContext.GROUND, (LivingEntity)dog);
    }

    private void updateAndRenderItem_1_21_5(Dog dog, ItemStack itemStack, PoseStack stack, MultiBufferSource bufferSource, int packedLight) {
        this.updateMouthItemRenderState_1_21_5(dog, itemStack);
        this.mouthItemRenderState_1_21_5.render(stack, bufferSource, packedLight, OverlayTexture.NO_OVERLAY);
    }
}

