/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render.layer.accessory;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import doggytalents.DoggyTalents;
import doggytalents.api.backward_imitate.ItemUtil_1_21_5;
import doggytalents.client.ClientSetup;
import doggytalents.client.backward_imitate.BaseModel_21_3;
import doggytalents.client.backward_imitate.DogRenderLayer_21_3;
import doggytalents.client.backward_imitate.DogRenderState_21_3;
import doggytalents.client.entity.model.DogArmorModel;
import doggytalents.client.entity.model.SyncedRenderFunctionWithHeadModel;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.client.entity.render.DoggyArmorMapping;
import doggytalents.client.entity.render.layer.DogArmorHelmetAltModel;
import doggytalents.client.entity.skin.DogSkin;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.ItemUtil;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimPattern;

public class DoggyArmorRenderer
extends DogRenderLayer_21_3 {
    private DogArmorModel model;
    private DogArmorModel newModel;
    private DogArmorModel legacyModel;
    private SyncedRenderFunctionWithHeadModel alternativeModel;
    private boolean initAltModel = false;
    private DogArmorHelmetAltModel helmetAltModel;
    private final TextureAtlas dogArmorTrimAtlas;
    private Function<TrimSpriteKey, TextureAtlasSprite> trimSpriteLookup;

    public DoggyArmorRenderer(RenderLayerParent parentRenderer, EntityRendererProvider.Context ctx) {
        super((RenderLayerParent<DogRenderState_21_3, DogModel>)parentRenderer);
        this.newModel = new DogArmorModel(ctx.bakeLayer(ClientSetup.DOG_ARMOR));
        this.legacyModel = new DogArmorModel(ctx.bakeLayer(ClientSetup.DOG_ARMOR_LEGACY));
        this.alternativeModel = new SyncedRenderFunctionWithHeadModel(ctx.bakeLayer(ClientSetup.DOG_SYNCED_FUNCTION_WITH_HEAD));
        this.model = this.newModel;
        this.helmetAltModel = new DogArmorHelmetAltModel(ctx);
        this.dogArmorTrimAtlas = ctx.getModelManager().getAtlas(Sheets.ARMOR_TRIMS_SHEET);
        this.initLookup_1_21_3();
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Dog dog, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        DogModel model;
        if (!dog.isTame() || dog.isInvisible()) {
            return;
        }
        if (!((Boolean)ConfigHandler.CLIENT.RENDER_ARMOR.get()).booleanValue() || dog.hideArmor()) {
            return;
        }
        DogSkin skin = dog.getClientSkin();
        if (skin.useCustomModel() && !(model = skin.getCustomModel().getValue()).armorShouldRender(dog)) {
            return;
        }
        Optional inst = dog.getTalent(DoggyTalents.DOGGY_ARMOR);
        if (!inst.isPresent()) {
            return;
        }
        this.model = (Boolean)ConfigHandler.CLIENT.USE_LEGACY_DOG_ARMOR_RENDER.get() != false ? this.legacyModel : this.newModel;
        DogModel parentModel = (DogModel)this.getParentModel();
        parentModel.copyPropertiesTo(this.model);
        this.model.sync(parentModel);
        this.initAltModel = false;
        this.checkAndRenderSlot(dog, EquipmentSlot.HEAD, poseStack, buffer, packedLight);
        this.checkAndRenderSlot(dog, EquipmentSlot.CHEST, poseStack, buffer, packedLight);
        this.checkAndRenderSlot(dog, EquipmentSlot.LEGS, poseStack, buffer, packedLight);
        this.checkAndRenderSlot(dog, EquipmentSlot.FEET, poseStack, buffer, packedLight);
    }

    private void checkAndRenderSlot(Dog dog, EquipmentSlot slot, PoseStack stack, MultiBufferSource buffer, int light) {
        ItemStack itemStack = dog.getItemBySlot(slot);
        Item item = itemStack.getItem();
        if (!ItemUtil_1_21_5.isHumanoidArmor(itemStack)) {
            return;
        }
        switch (slot) {
            case HEAD: {
                this.model.setHelmet();
                break;
            }
            case CHEST: {
                this.model.setChestplate();
                break;
            }
            case LEGS: {
                this.model.setLeggings();
                break;
            }
            case FEET: {
                this.model.setBoot();
                break;
            }
            default: {
                return;
            }
        }
        Optional<Model> altModel = this.getAlternativeArmorModel(dog, slot, stack, itemStack);
        if (altModel.isPresent()) {
            if (!this.initAltModel) {
                this.initAltModel = true;
                DogModel parentModel = (DogModel)this.getParentModel();
                parentModel.copyPropertiesTo(this.alternativeModel);
                this.alternativeModel.sync(parentModel);
            }
            this.startRenderAlternativeModelFromRoot(altModel.get(), dog, stack, buffer, light, itemStack, item);
            return;
        }
        this.renderArmorCutout(this.model, DoggyArmorMapping.getMappedResource(itemStack.getItem(), dog, itemStack), stack, buffer, light, dog, 1.0f, 1.0f, 1.0f);
        Optional<ArmorTrim> trim = ItemUtil.getTrim(itemStack);
        if (trim.isPresent()) {
            this.renderTrim(stack, buffer, light, trim.get(), this.model, ItemUtil.getEquippableModelUnsafe_1_21_3(itemStack));
        }
        if (itemStack.hasFoil()) {
            this.renderGlint(stack, buffer, light, this.model);
        }
    }

    private Optional<Model> getAlternativeArmorModel(Dog dog, EquipmentSlot slot, PoseStack stack, ItemStack itemStack) {
        if (slot == EquipmentSlot.HEAD && ((Boolean)ConfigHandler.CLIENT.USE_PLAYER_HELMET_MODEL_BY_DEFAULT.get()).booleanValue()) {
            return Optional.of(this.helmetAltModel.getModel());
        }
        return Optional.empty();
    }

    private void startRenderAlternativeModelFromRoot(Model model, Dog dog, PoseStack stack, MultiBufferSource buffer, int light, ItemStack itemStack, Item armor) {
        this.alternativeModel.startRenderFromRoot(stack, stack1 -> {
            stack1.pushPose();
            stack1.scale(0.6f, 0.6f, 0.6f);
            stack1.translate(0.0, (double)0.15f, 0.07);
            this.renderAlternativeModel(model, dog, stack1, buffer, light, itemStack);
            Optional<ArmorTrim> trim = ItemUtil.getTrim(itemStack);
            if (trim.isPresent()) {
                this.renderTrim(stack, buffer, light, trim.get(), BaseModel_21_3.wrap(model), ItemUtil.getEquippableModelUnsafe_1_21_3(itemStack));
            }
            if (itemStack.hasFoil()) {
                this.renderGlint(stack, buffer, light, BaseModel_21_3.wrap(model));
            }
            stack1.popPose();
        });
    }

    private void renderAlternativeModel(Model model, Dog dog, PoseStack stack, MultiBufferSource buffer, int light, ItemStack itemStack) {
        ResourceLocation texLoc = DoggyArmorMapping.getMappedResource(itemStack.getItem(), dog, itemStack);
        VertexConsumer ivertexbuilder = buffer.getBuffer(RenderType.armorCutoutNoCull((ResourceLocation)texLoc));
        model.renderToBuffer(stack, ivertexbuilder, light, OverlayTexture.NO_OVERLAY, -1);
    }

    private void renderArmorCutout(DogArmorModel model, ResourceLocation textureLocationIn, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, Dog entityIn, float red, float green, float blue) {
        VertexConsumer ivertexbuilder = bufferIn.getBuffer(RenderType.armorCutoutNoCull((ResourceLocation)textureLocationIn));
        model.renderToBuffer(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, ARGB.colorFromFloat((float)1.0f, (float)red, (float)green, (float)blue));
    }

    private void renderTrim(PoseStack stack, MultiBufferSource buffer, int light, ArmorTrim trim, BaseModel_21_3 model, ResourceKey<EquipmentAsset> armor_model) {
        TextureAtlasSprite textureatlassprite = this.trimSpriteLookup.apply(new TrimSpriteKey(trim, EquipmentClientInfo.LayerType.HUMANOID, armor_model));
        VertexConsumer vertexconsumer = textureatlassprite.wrap(buffer.getBuffer(Sheets.armorTrimsSheet((boolean)((TrimPattern)trim.pattern().value()).decal())));
        model.renderToBuffer(stack, vertexconsumer, light, OverlayTexture.NO_OVERLAY, -1);
    }

    private void renderGlint(PoseStack stack, MultiBufferSource buffer, int light, BaseModel_21_3 model) {
        model.renderToBuffer(stack, buffer.getBuffer(RenderType.armorEntityGlint()), light, OverlayTexture.NO_OVERLAY, -1);
    }

    private void initLookup_1_21_3() {
        this.trimSpriteLookup = Util.memoize(p_371220_ -> {
            ResourceLocation resourcelocation = p_371220_.trim.layerAssetId(p_371220_.layerType.trimAssetPrefix(), p_371220_.equipmentModelId);
            return this.dogArmorTrimAtlas.getSprite(resourcelocation);
        });
    }

    record TrimSpriteKey(ArmorTrim trim, EquipmentClientInfo.LayerType layerType, ResourceKey<EquipmentAsset> equipmentModelId) {
    }
}

