/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.AmnesiaBoneScreen.screen;

import doggytalents.client.screen.ScreenUtil;
import doggytalents.client.screen.framework.widget.TextOnlyButton;
import doggytalents.client.screen.widget.CustomButton;
import doggytalents.common.entity.Dog;
import doggytalents.common.item.AmnesiaBoneItem;
import doggytalents.common.network.PacketDistributor;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.DogMigrateOwnerData;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.joml.Matrix3x2fStack;

public class DogMigrateOwnerScreen
extends Screen {
    private Dog dog;
    @Nullable
    private UUID migrateTo;
    private String migrateToStr;
    private TextOnlyButton uuidShowButton;

    protected DogMigrateOwnerScreen(Dog dog, @Nullable UUID migrateTo, String ownerName) {
        super((Component)Component.literal((String)""));
        this.dog = dog;
        this.migrateTo = migrateTo;
        this.migrateToStr = ownerName;
    }

    public static void open(Dog dog, UUID migrateTo, String ownerName) {
        Minecraft mc = Minecraft.getInstance();
        DogMigrateOwnerScreen screen = new DogMigrateOwnerScreen(dog, migrateTo, ownerName == null ? "" : ownerName);
        mc.setScreen((Screen)screen);
    }

    protected void init() {
        this.uuidShowButton = new TextOnlyButton(0, 0, 100, 20, (Component)Component.translatable((String)"doggui.migrate_owner.show_uuid").withStyle(ChatFormatting.GRAY), b -> {}, Minecraft.getInstance().font){

            @Override
            public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
                super.renderWidget(graphics, mouseX, mouseY, pTicks);
                if (!this.isHovered) {
                    return;
                }
                ScreenUtil.renderComponentTooltip_21_5(graphics, DogMigrateOwnerScreen.this.font, List.of(Component.literal((String)(DogMigrateOwnerScreen.this.migrateTo == null ? "UUID_ZERO" : DogMigrateOwnerScreen.this.migrateTo.toString()))), mouseX, mouseY);
            }
        };
        if (this.migrateTo == null) {
            return;
        }
        this.addConfirmButton();
        this.addDenyButton();
        this.addRenderableWidget((GuiEventListener)this.uuidShowButton);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
        super.render(graphics, mouseX, mouseY, pTicks);
        Matrix3x2fStack stack = graphics.pose();
        if (this.migrateTo != null) {
            this.drawWhenHaveRequest(graphics, mouseX, mouseY, pTicks, this.migrateTo, this.migrateToStr);
            return;
        }
        int mX = this.width / 2;
        int mY = this.height / 2;
        int pY = mY - 72;
        MutableComponent title = Component.translatable((String)"doggui.migrate_owner.help.title").withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(ChatFormatting.RED));
        List help = this.font.split((FormattedText)Component.translatable((String)"doggui.migrate_owner.help.subtitle"), 300);
        String escToReturn = I18n.get((String)"doggui.invalid_dog.esc_to_return", (Object[])new Object[0]);
        stack.pushMatrix();
        stack.scale(1.2f, 1.2f);
        graphics.drawString(this.font, (Component)title, Mth.floor((float)((float)mX / 1.2f - (float)(this.font.width((FormattedText)title) / 2))), Mth.floor((float)((float)pY / 1.2f)), -1);
        stack.popMatrix();
        pY += 40;
        for (FormattedCharSequence line : help) {
            graphics.drawString(this.font, line, mX - this.font.width(line) / 2, pY, -1);
            Objects.requireNonNull(this.font);
            pY += 9 + 3;
        }
        graphics.drawString(this.font, escToReturn, mX - this.font.width(escToReturn) / 2, pY += 40, -1);
    }

    public void drawWhenHaveRequest(GuiGraphics graphics, int mouseX, int mouseY, float pTicks, UUID newOwnerUUID, String newOwnerName) {
        Matrix3x2fStack stack = graphics.pose();
        int mX = this.width / 2;
        int mY = this.height / 2;
        int pY = mY - 72;
        MutableComponent title = Component.translatable((String)"doggui.migrate_owner.confirm.title").withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(ChatFormatting.RED));
        String help = I18n.get((String)"doggui.migrate_owner.confirm.subtitle", (Object[])new Object[]{this.dog.getName().getString()});
        String dog_title = I18n.get((String)"doggui.migrate_owner.info.dog", (Object[])new Object[]{this.dog.getName().getString()});
        MutableComponent owner_title = Component.translatable((String)"doggui.migrate_owner.info.new_owner", (Object[])new Object[]{newOwnerName});
        String costStr = I18n.get((String)"doggui.talents.cost", (Object[])new Object[0]) + AmnesiaBoneItem.getMigrateOwnerXPCost();
        String escToReturn = I18n.get((String)"doggui.invalid_dog.esc_to_return", (Object[])new Object[0]);
        stack.pushMatrix();
        stack.scale(1.2f, 1.2f);
        graphics.drawString(this.font, (Component)title, Mth.floor((float)((float)mX / 1.2f - (float)(this.font.width((FormattedText)title) / 2))), Mth.floor((float)((float)pY / 1.2f)), -1);
        stack.popMatrix();
        graphics.drawString(this.font, help, mX - this.font.width(help) / 2, pY += 40, -1);
        graphics.drawString(this.font, dog_title, mX - this.font.width(dog_title) / 2, pY += 40, -1);
        Objects.requireNonNull(this.font);
        graphics.drawString(this.font, (Component)owner_title, mX - this.font.width((FormattedText)owner_title) / 2, pY += 9 + 3, -1);
        Objects.requireNonNull(this.font);
        this.uuidShowButton.setX(this.width / 2 - this.uuidShowButton.getWidth() / 2);
        this.uuidShowButton.setY((pY += 9 + 3) - 6);
        Objects.requireNonNull(this.font);
        graphics.drawString(this.font, costStr, mX - this.font.width(costStr) / 2, pY += 9 + 6, -1);
        graphics.drawString(this.font, escToReturn, mX - this.font.width(escToReturn) / 2, pY += 40, -1);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private void addConfirmButton() {
        var confirmButton = new CustomButton(this.width / 2 + 2, this.height / 2 + 58, 50, 20, (Component)Component.translatable((String)"doggui.migrate_owner.confirm"), b -> {
            this.requestMigrateOwner(true);
            Minecraft.getInstance().setScreen(null);
        }){

            public void renderWidgetMain(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
                LocalPlayer player = Minecraft.getInstance().player;
                this.active = player != null && player.experienceLevel >= AmnesiaBoneItem.getMigrateOwnerXPCost();
            }

            public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
                super.renderWidget(graphics, mouseX, mouseY, pTicks);
                this.renderWidgetMain(graphics, mouseX, mouseY, pTicks);
                if (!this.isHovered) {
                    return;
                }
                if (this.active) {
                    return;
                }
                LocalPlayer player = Minecraft.getInstance().player;
                if (player == null || player.experienceLevel >= AmnesiaBoneItem.getMigrateOwnerXPCost()) {
                    return;
                }
                MutableComponent c1 = Component.translatable((String)"doggui.detrain.talents.insufficent_xp");
                c1.setStyle(Style.EMPTY.withColor(-5111808).withBold(Boolean.valueOf(true)));
                ScreenUtil.renderComponentTooltip_21_5(graphics, DogMigrateOwnerScreen.this.font, List.of(c1), mouseX, mouseY);
            }
        };
        LocalPlayer player = Minecraft.getInstance().player;
        confirmButton.active = player != null && player.experienceLevel >= AmnesiaBoneItem.getMigrateOwnerXPCost();
        this.addRenderableWidget((GuiEventListener)confirmButton);
    }

    public void addDenyButton() {
        CustomButton denyButton = new CustomButton(this.width / 2 - 50 - 2, this.height / 2 + 58, 50, 20, (Component)Component.translatable((String)"doggui.migrate_owner.deny"), b -> {
            this.requestMigrateOwner(false);
            Minecraft.getInstance().setScreen(null);
        });
        this.addRenderableWidget((GuiEventListener)denyButton);
    }

    private void requestMigrateOwner(boolean confirmed) {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogMigrateOwnerData(this.dog.getId(), confirmed));
    }
}

