/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.DogNewInfoScreen.element.view.MainInfoView.dropdown.AddGroupMenu;

import doggytalents.client.screen.framework.element.AbstractElement;
import doggytalents.client.screen.framework.widget.FlatButton;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class ColorSelectElement
extends AbstractElement {
    public static int BUTTON_SIZE = 12;
    public static int BUTTON_SPACING = 2;
    public int selectedColor = COLORS[0];
    public static int PADDING_HORZ = 5;
    private ArrayList<ColorButton> colorButtons;
    private static int[] COLORS = new int[]{-580829, -13452036, -13435740, -1183689, -4631847, -1871818, -9835195, -13802026, -13773866, -8296723};

    public ColorSelectElement(AbstractElement parent, Screen screen) {
        super(parent, screen);
    }

    @Override
    public AbstractElement init() {
        int aX;
        this.colorButtons = new ArrayList(10);
        int pX = aX = this.getRealX() + PADDING_HORZ;
        int pY = this.getRealY();
        int rowSize = Mth.floor((float)((BUTTON_SPACING - PADDING_HORZ * 2 + this.getSizeX()) / (BUTTON_SIZE + BUTTON_SPACING)));
        int color_indx = 0;
        while (color_indx < COLORS.length) {
            pX = aX;
            for (int i = 0; i < rowSize; ++i) {
                ColorButton button = new ColorButton(pX, pY, COLORS[color_indx], b -> {
                    this.selectedColor = b.getColor();
                });
                this.colorButtons.add(button);
                this.addChildren((GuiEventListener)button);
                pX += BUTTON_SIZE + BUTTON_SPACING;
                if (++color_indx >= COLORS.length) break;
            }
            pY += BUTTON_SIZE + BUTTON_SPACING;
        }
        return this;
    }

    @Override
    public void renderElement(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        for (ColorButton colorButton : this.colorButtons) {
            colorButton.selected = this.selectedColor == colorButton.getColor();
        }
    }

    private static class ColorButton
    extends FlatButton {
        private int color;
        private OnPress onPress;
        public boolean selected;

        public ColorButton(int x, int y, int color, OnPress onPress) {
            super(x, y, BUTTON_SIZE, BUTTON_SIZE, (Component)Component.empty(), null);
            this.color = color;
            this.onPress = onPress;
        }

        public int getColor() {
            return this.color;
        }

        @Override
        public void onPress() {
            this.onPress.onPress(this);
        }

        @Override
        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
            if (!this.active) {
                return;
            }
            if (this.selected) {
                graphics.fill(this.getX() - 1, this.getY() - 1, this.getX() + this.width + 1, this.getY() + this.height + 1, -1);
            }
            graphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, this.color);
        }

        public static interface OnPress {
            public void onPress(ColorButton var1);
        }
    }
}

