/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen;

import doggytalents.client.screen.ScreenUtil;
import doggytalents.common.block.tileentity.RiceMillBlockEntity;
import doggytalents.common.inventory.container.RiceMillMenu;
import doggytalents.common.lib.Resources;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class RiceMillScreen
extends AbstractContainerScreen<RiceMillMenu> {
    private RiceMillMenu menu;

    public RiceMillScreen(RiceMillMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        this.menu = menu;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        ScreenUtil.blit_21_3(graphics, Resources.RICE_MILL_GUI, x, y, 0, 0, this.imageWidth, this.imageHeight);
        this.blitProgressArrow(graphics);
        this.blitWaterBucket(graphics);
    }

    private void blitProgressArrow(GuiGraphics graphics) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        float grindProg = this.menu.getGrindProgress();
        int filledArrow = this.getFilledArrow(grindProg);
        ScreenUtil.blit_21_3(graphics, Resources.RICE_MILL_GUI, x + 79, y + 34, 176, 14, filledArrow, 17);
    }

    private int getFilledArrow(float progress) {
        int ret = Mth.ceil((float)(24.0f * progress));
        return Mth.clamp((int)ret, (int)0, (int)24);
    }

    private void blitWaterBucket(GuiGraphics graphics) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        RiceMillBlockEntity clientMill = this.menu.getClientMill();
        if (clientMill == null) {
            return;
        }
        if (clientMill.isRemoved()) {
            return;
        }
        boolean isSpinning = clientMill.isSpinning();
        if (!isSpinning) {
            return;
        }
        ScreenUtil.blit_21_3(graphics, Resources.RICE_MILL_GUI, x + 82, y + 29, 176, 31, 11, 10);
    }
}

