/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.framework.element;

import doggytalents.client.screen.framework.element.AbstractElement;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.events.GuiEventListener;

public class ElementPosition {
    private AbstractElement element;
    private int x;
    private int y;
    private int originAbsoluteX;
    private int originAbsoluteY;
    private ChildDirection dir = ChildDirection.ROW;
    private PosType type = PosType.FIXED;
    private int scrollYOffset;

    public ElementPosition(@Nonnull AbstractElement element, int x, int y, PosType type) {
        this.element = element;
        this.x = x;
        this.y = y;
        this.type = type;
        if (this.type == PosType.RELATIVE) {
            this.computeOriginAbsolute();
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getRealX() {
        if (this.type == PosType.FIXED) {
            return this.x;
        }
        int realX = this.type == PosType.RELATIVE ? this.originAbsoluteX + this.x : this.x;
        for (AbstractElement p = this.element.getParent(); p != null; p = p.getParent()) {
            ElementPosition pPos = p.getPosition();
            if (pPos.type == PosType.FIXED) {
                realX += pPos.x;
                break;
            }
            realX += pPos.type == PosType.RELATIVE ? pPos.originAbsoluteX + pPos.x : pPos.x;
        }
        return realX;
    }

    public int getRealY() {
        int realY;
        if (this.type == PosType.FIXED) {
            return this.y;
        }
        int n = realY = this.type == PosType.RELATIVE ? this.originAbsoluteY + this.y : this.y;
        if (this.type == PosType.SCROLL_ABSOLUTE) {
            realY -= this.scrollYOffset;
        }
        for (AbstractElement p = this.element.getParent(); p != null; p = p.getParent()) {
            ElementPosition pPos = p.getPosition();
            if (pPos.type == PosType.FIXED) {
                realY += pPos.y;
                break;
            }
            realY += pPos.type == PosType.RELATIVE ? pPos.originAbsoluteY + pPos.y : pPos.y;
            if (pPos.type != PosType.SCROLL_ABSOLUTE) continue;
            realY -= pPos.scrollYOffset;
        }
        return realY;
    }

    private void computeOriginAbsolute() {
        AbstractElement p = this.element.getParent();
        if (p == null) {
            this.originAbsoluteX = 0;
            this.originAbsoluteY = 0;
            return;
        }
        ChildDirection dir = p.getPosition().getChildDirection();
        List<? extends GuiEventListener> pChilds = p.children();
        if (pChilds == null || pChilds.isEmpty()) {
            this.originAbsoluteX = 0;
            this.originAbsoluteY = 0;
            return;
        }
        int indx = pChilds.size() - 1;
        GuiEventListener lastChild = pChilds.get(indx);
        if (lastChild == this) {
            --indx;
        }
        for (int i = 0; i <= indx; ++i) {
            GuiEventListener guiEvLis = pChilds.get(i);
            if (!(guiEvLis instanceof AbstractElement)) continue;
            AbstractElement e = (AbstractElement)guiEvLis;
            if (e.getPosition().type != PosType.RELATIVE) continue;
            if (dir == ChildDirection.COL) {
                this.originAbsoluteY += e.getSizeY();
                continue;
            }
            this.originAbsoluteX += e.getSizeX();
        }
    }

    public PosType getType() {
        return this.type;
    }

    public ChildDirection getChildDirection() {
        return this.dir;
    }

    public void setChildDirection(ChildDirection dir) {
        this.dir = dir;
    }

    public void setScrollYOffset(int off) {
        this.scrollYOffset = off;
    }

    public int getScrollYOffset() {
        return this.scrollYOffset;
    }

    public static ElementPosition getDefault(@Nonnull AbstractElement element) {
        return new ElementPosition(element, 0, 0, PosType.RELATIVE);
    }

    public static enum ChildDirection {
        COL,
        ROW;

    }

    public static enum PosType {
        RELATIVE,
        ABSOLUTE,
        FIXED,
        SCROLL_ABSOLUTE;

    }
}

