/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.block;

import com.mojang.serialization.MapCodec;
import doggytalents.DoggyEntityTypes;
import doggytalents.DoggyItems;
import doggytalents.DoggyTalentsNext;
import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.api.backward_imitate.DogInteractionResult;
import doggytalents.api.backward_imitate.HoverTextAppender_1_21_5;
import doggytalents.api.registry.IBeddingMaterial;
import doggytalents.api.registry.ICasingMaterial;
import doggytalents.common.backward_imitate.ResourceKeyHelper_21_3;
import doggytalents.common.block.tileentity.DogBedTileEntity;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.DogMoveToBedAction;
import doggytalents.common.storage.DogRespawnData;
import doggytalents.common.storage.DogRespawnStorage;
import doggytalents.common.util.DogBedUtil;
import doggytalents.common.util.EntityUtil;
import doggytalents.common.util.ItemUtil;
import doggytalents.common.util.NBTUtil;
import doggytalents.common.util.PlayerUtil;
import doggytalents.common.util.WorldUtil;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.Pair;

public class DogBedBlock
extends BaseEntityBlock
implements HoverTextAppender_1_21_5 {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
    protected static final VoxelShape SHAPE_COLLISION = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);
    public static final MapCodec<DogBedBlock> CODEC = DogBedBlock.simpleCodec(DogBedBlock::new);

    public DogBedBlock() {
        super(BlockBehaviour.Properties.of().setId(ResourceKeyHelper_21_3.blockKey("dog_bed")).mapColor(MapColor.WOOD).strength(1.0f, 5.0f).sound(SoundType.WOOD));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public DogBedBlock(BlockBehaviour.Properties props) {
        this();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext selectionContext) {
        return SHAPE_COLLISION;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState blockState) {
        return new DogBedTileEntity(pos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return null;
    }

    public RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        state = (BlockState)state.setValue(FACING, (Comparable)placer.getDirection().getOpposite());
        DogBedTileEntity dogBedTileEntity = WorldUtil.getTileEntity((BlockGetter)worldIn, pos, DogBedTileEntity.class);
        if (dogBedTileEntity != null) {
            DogBedUtil.setBedVariant(dogBedTileEntity, stack);
            dogBedTileEntity.setPlacer(placer);
            CompoundTag_1_21_5 tag = ItemUtil.getTagElement(stack, "doggytalents");
            if (tag != null) {
                Component name = NBTUtil.getTextComponent(tag, "name");
                UUID ownerId = NBTUtil.getUniqueId(tag, "ownerId");
                dogBedTileEntity.setBedName(name);
                dogBedTileEntity.setOwner(ownerId);
            }
        }
        worldIn.setBlock(pos, state, 2);
    }

    public BlockState updateShape(BlockState stateIn, LevelReader worldIn, ScheduledTickAccess tickAccess, BlockPos currentPos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            tickAccess.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(worldIn));
        }
        return facing == Direction.DOWN && !stateIn.canSurvive(worldIn, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(stateIn, worldIn, tickAccess, currentPos, facing, facingPos, facingState, random);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }

    @Deprecated
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        DogBedTileEntity tile = WorldUtil.getTileEntity((BlockGetter)level, pos, DogBedTileEntity.class);
        if (tile == null) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.getMainHandItem();
        if (this.handleNameTagBed(player, level, state, pos, tile, stack).shouldSwing()) {
            return InteractionResult.SUCCESS;
        }
        if (this.handleDogRandomRespawn(player, level, state, pos, tile, stack).shouldSwing()) {
            return InteractionResult.SUCCESS;
        }
        if (this.handleDogClaimBed(player, level, state, pos, tile, stack).shouldSwing()) {
            return InteractionResult.SUCCESS;
        }
        if (this.handleDogRespawn(player, level, state, pos, tile, stack).shouldSwing()) {
            return InteractionResult.SUCCESS;
        }
        if (this.handleDogReclaim(player, level, state, pos, tile, stack).shouldSwing()) {
            return InteractionResult.SUCCESS;
        }
        if (tile.getOwnerUUID() != null) {
            Component name = tile.getOwnerName();
            PlayerUtil.sendSystemMessage((LivingEntity)player, (Component)Component.translatable((String)"block.doggytalents.dog_bed.owner", (Object[])new Object[]{name != null ? name : "someone"}));
        } else {
            PlayerUtil.sendSystemMessage((LivingEntity)player, (Component)Component.translatable((String)"block.doggytalents.dog_bed.set_owner_help"));
        }
        return InteractionResult.SUCCESS;
    }

    private DogInteractionResult handleDogRandomRespawn(Player player, Level level, BlockState state, BlockPos pos, DogBedTileEntity tile, ItemStack stack) {
        if (tile.getOwnerUUID() != null) {
            return DogInteractionResult.PASS;
        }
        if (!stack.is(Items.TOTEM_OF_UNDYING)) {
            return DogInteractionResult.PASS;
        }
        if (PlayerUtil.isOnCooldown(player, Items.TOTEM_OF_UNDYING)) {
            return DogInteractionResult.PASS;
        }
        DogRespawnStorage storage = DogRespawnStorage.get(level);
        Predicate<DogRespawnData> isFromOwner = filter_data -> {
            UUID owner_id = filter_data.getOwnerId();
            if (owner_id == null) {
                return false;
            }
            return !ObjectUtils.notEqual((Object)owner_id, (Object)player.getUUID());
        };
        List dataList = storage.getAll().stream().filter(isFromOwner).collect(Collectors.toList());
        if (dataList.isEmpty()) {
            return DogInteractionResult.PASS;
        }
        int dataListSize = dataList.size();
        int rIndx = player.getRandom().nextInt(dataListSize);
        UUID rUUID = ((DogRespawnData)dataList.get(rIndx)).getDogId();
        DogRespawnData dogData = storage.remove(rUUID);
        if (dogData == null) {
            return DogInteractionResult.SUCCESS;
        }
        Dog dog = dogData.respawn((ServerLevel)level, player, pos.above());
        if (dog == null) {
            return DogInteractionResult.SUCCESS;
        }
        tile.setOwner(dog);
        dog.setBedPos((ResourceKey<Level>)dog.level().dimension(), pos);
        dog.level().broadcastEntityEvent((Entity)dog, (byte)35);
        if (!player.getAbilities().instabuild) {
            stack.shrink(1);
        }
        PlayerUtil.addCooldown(player, Items.TOTEM_OF_UNDYING, 60);
        return DogInteractionResult.SUCCESS;
    }

    private DogInteractionResult handleDogReclaim(Player player, Level level, BlockState state, BlockPos pos, DogBedTileEntity tile, ItemStack stack) {
        UUID owner_id = tile.getOwnerUUID();
        if (owner_id == null) {
            return DogInteractionResult.PASS;
        }
        if (!player.isShiftKeyDown()) {
            return DogInteractionResult.PASS;
        }
        this.reclaimBed(player, (ServerLevel)level, tile, pos);
        return DogInteractionResult.SUCCESS;
    }

    private DogInteractionResult handleDogRespawn(Player player, Level level, BlockState state, BlockPos pos, DogBedTileEntity tile, ItemStack stack) {
        UUID owner_id = tile.getOwnerUUID();
        if (owner_id == null) {
            return DogInteractionResult.PASS;
        }
        DogRespawnStorage storage = DogRespawnStorage.get(level);
        DogRespawnData data = storage.remove(owner_id);
        if (data == null) {
            return DogInteractionResult.PASS;
        }
        Dog dog = data.respawn((ServerLevel)level, player, pos.above());
        if (dog == null) {
            return DogInteractionResult.SUCCESS;
        }
        tile.setOwner(dog);
        dog.setBedPos((ResourceKey<Level>)dog.level().dimension(), pos);
        return DogInteractionResult.SUCCESS;
    }

    private DogInteractionResult handleDogClaimBed(Player player, Level level, BlockState state, BlockPos pos, DogBedTileEntity tile, ItemStack stack) {
        Dog closest;
        boolean isAssign;
        if (tile.getOwnerUUID() != null) {
            return DogInteractionResult.PASS;
        }
        boolean bl = isAssign = player.isShiftKeyDown() || stack.is(Items.BONE) || stack.is(DoggyItems.TRAINING_TREAT.get());
        if (!isAssign) {
            return DogInteractionResult.PASS;
        }
        Predicate<Dog> isValidDog = valid_dog -> valid_dog.isDoingFine() && valid_dog.isOwnedBy((LivingEntity)player) && !valid_dog.isOrderedToSit();
        List dogs = level.getEntities((EntityTypeTest)DoggyEntityTypes.DOG.get(), new AABB(pos).inflate(10.0), isValidDog);
        Collections.sort(dogs, new EntityUtil.Sorter(Vec3.atBottomCenterOf((Vec3i)pos)));
        Dog dog = closest = dogs.isEmpty() ? null : (Dog)dogs.get(0);
        if (pos != null && closest != null && closest.readyForNonTrivialAction()) {
            closest.triggerAction(new DogMoveToBedAction(closest, pos, true));
        }
        return DogInteractionResult.SUCCESS;
    }

    private DogInteractionResult handleNameTagBed(Player player, Level level, BlockState state, BlockPos pos, DogBedTileEntity tile, ItemStack stack) {
        if (!stack.is(Items.NAME_TAG)) {
            return DogInteractionResult.PASS;
        }
        if (!ItemUtil.hasCustomHoverName(stack)) {
            return DogInteractionResult.PASS;
        }
        tile.setBedName(stack.getHoverName());
        if (!player.getAbilities().instabuild) {
            stack.shrink(1);
        }
        level.sendBlockUpdated(pos, state, state, 3);
        return DogInteractionResult.SUCCESS;
    }

    private boolean reclaimBed(Player player, ServerLevel level, DogBedTileEntity bedEntity, BlockPos pos) {
        Entity e = level.getEntity(bedEntity.getOwnerUUID());
        if (!(e instanceof Dog)) {
            return false;
        }
        Dog dog = (Dog)e;
        Optional<BlockPos> bedPosOptional = dog.getBedPos();
        if (!bedPosOptional.isPresent()) {
            return false;
        }
        BlockPos bedPos = bedPosOptional.get();
        if (bedPos.equals((Object)pos)) {
            return false;
        }
        dog.setBedPos(pos);
        PlayerUtil.sendSystemMessage((LivingEntity)player, (Component)Component.translatable((String)"block.doggytalents.dog_bed.reclaim", (Object[])new Object[]{dog.getName().getString(), dog.getGenderPossessiveAdj()}));
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag_1_21_5 tag;
        HoverTextAppender_1_21_5.super.appendHoverText(stack, context, tooltip, flagIn);
        Pair<ICasingMaterial, IBeddingMaterial> materials = DogBedUtil.getMaterials(stack);
        tooltip.add((Component)Component.translatable((String)"dogbed.casing.title"));
        tooltip.add((Component)(materials.getLeft() != null ? ((ICasingMaterial)materials.getLeft()).getTooltip() : Component.translatable((String)"dogbed.casing.null").withStyle(ChatFormatting.RED)));
        tooltip.add((Component)Component.translatable((String)"dogbed.bedding.title"));
        tooltip.add((Component)(materials.getRight() != null ? ((IBeddingMaterial)materials.getRight()).getTooltip() : Component.translatable((String)"dogbed.bedding.null").withStyle(ChatFormatting.RED)));
        if (materials.getLeft() == null && materials.getRight() == null) {
            tooltip.add((Component)Component.translatable((String)"dogbed.explain.missing").withStyle(ChatFormatting.ITALIC));
        }
        if ((tag = ItemUtil.getTagElement(stack, "doggytalents")) != null) {
            UUID ownerId = NBTUtil.getUniqueId(tag, "ownerId");
            Component name = NBTUtil.getTextComponent(tag, "name");
            Component ownerName = NBTUtil.getTextComponent(tag, "ownerName");
            if (name != null) {
                tooltip.add((Component)Component.literal((String)"Bed Name: ").withStyle(ChatFormatting.WHITE).append(name));
            }
            if (ownerName != null) {
                tooltip.add((Component)Component.literal((String)"Name: ").withStyle(ChatFormatting.DARK_AQUA).append(ownerName));
            }
            if (ownerId != null && (flagIn.isAdvanced() || Screen.hasShiftDown())) {
                tooltip.add((Component)Component.literal((String)"UUID: ").withStyle(ChatFormatting.AQUA).append((Component)Component.literal((String)ownerId.toString())));
            }
        }
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state, boolean includeData, Player player) {
        DogBedTileEntity dogBedTileEntity = WorldUtil.getTileEntity((BlockGetter)world, pos, DogBedTileEntity.class);
        if (dogBedTileEntity != null) {
            return DogBedUtil.createItemStack(dogBedTileEntity.getCasing(), dogBedTileEntity.getBedding());
        }
        DoggyTalentsNext.LOGGER.debug("Unable to pick block on dog bed.");
        return ItemStack.EMPTY;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }
}

