/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import doggytalents.api.backward_imitate.InteractionResultHolder;
import doggytalents.api.feature.DogMode;
import doggytalents.api.inferface.IDogAlteration;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.Util;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class DogHungerManager {
    public static final ResourceLocation HUNGER_MOVEMENT = Util.getResource("dog_hunger_slowndown");
    public static final float MAX_HUNGER_TICK = 800.0f;
    private final Dog dog;
    private float hungerTick = 0.0f;
    private int saturation = 0;
    private int saturationHealingTick = 0;
    private int hungerDamageTick = 0;
    private boolean lowHunger = false;
    private boolean zeroHunger = false;

    public DogHungerManager(Dog dog) {
        this.dog = dog;
    }

    public void tick() {
        this.handleHunger();
        this.mayHealWithSaturation();
    }

    private void handleHunger() {
        if (((Boolean)ConfigHandler.SERVER.DISABLE_HUNGER.get()).booleanValue()) {
            return;
        }
        if (this.dog.getMode() == DogMode.WANDERING && ((Boolean)ConfigHandler.SERVER.WANDERING_DOG_NON_HUNGER.get()).booleanValue()) {
            return;
        }
        if (this.dog.isDogInAnimDebug()) {
            return;
        }
        this.hungerTick += this.getIncreaseHungerTick();
        if (this.hungerTick >= 800.0f) {
            if (this.saturation > 0) {
                --this.saturation;
            } else {
                this.dog.setDogHunger(this.dog.getDogHunger() - 1.0f);
            }
            this.hungerTick = 0.0f;
        }
        if (this.zeroHunger) {
            this.handleZeroHunger();
        }
    }

    private float getIncreaseHungerTick() {
        float inc_tick = 0.0f;
        if (!this.dog.isVehicle() && !this.dog.isInSittingPose()) {
            inc_tick = 1.0f;
        }
        if (!this.dog.getNavigation().isDone()) {
            inc_tick = 2.0f;
        }
        for (IDogAlteration alter : this.dog.getAlterations()) {
            InteractionResultHolder<Float> result = alter.hungerTick(this.dog, inc_tick);
            if (!result.getResult().shouldSwing()) continue;
            inc_tick = result.getObject().floatValue();
        }
        float modifier = ((Double)ConfigHandler.SERVER.HUNGER_MODIFIER.get()).floatValue();
        return inc_tick * modifier;
    }

    private void handleZeroHunger() {
        ++this.hungerDamageTick;
        int hurt_interval = -1;
        boolean hurt_last_health = false;
        switch (this.dog.level().getDifficulty()) {
            case EASY: {
                hurt_interval = 125;
                break;
            }
            case NORMAL: {
                hurt_interval = 100;
                break;
            }
            case HARD: {
                hurt_interval = 75;
                hurt_last_health = true;
                break;
            }
            default: {
                hurt_interval = -1;
            }
        }
        if (hurt_interval >= 0 && ++this.hungerDamageTick >= hurt_interval && (hurt_last_health || this.dog.getHealth() > 1.0f)) {
            this.dog.hurt(this.dog.damageSources().starve(), 0.5f);
            this.hungerDamageTick = 0;
        }
    }

    private void mayHealWithSaturation() {
        if (this.saturation <= 0) {
            return;
        }
        if (this.dog.getHealth() >= this.dog.getMaxHealth()) {
            return;
        }
        if (--this.saturationHealingTick <= 0) {
            this.saturationHealingTick = 10;
            this.dog.heal(2.0f);
            this.saturation -= 3;
        }
    }

    public int saturation() {
        return this.saturation;
    }

    public boolean isLowHunger() {
        return this.lowHunger;
    }

    public void onHungerUpdated(float new_hunger) {
        boolean lowHunger_updated;
        if (this.dog.level().isClientSide) {
            return;
        }
        boolean bl = lowHunger_updated = new_hunger <= 10.0f;
        if (this.lowHunger && !lowHunger_updated) {
            this.hungerLowToHigh();
        }
        if (!this.lowHunger && lowHunger_updated) {
            this.hungerHighToLow();
        }
        this.lowHunger = lowHunger_updated;
        this.zeroHunger = new_hunger <= 0.0f;
    }

    private void hungerHighToLow() {
        if (!this.dog.isDefeated()) {
            this.dog.setAttributeModifier((Holder<Attribute>)Attributes.MOVEMENT_SPEED, HUNGER_MOVEMENT, (d, u) -> new AttributeModifier(u, (double)-0.35f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        }
    }

    private void hungerLowToHigh() {
        this.dog.removeAttributeModifier((Holder<Attribute>)Attributes.MOVEMENT_SPEED, HUNGER_MOVEMENT);
    }

    public void onBeingIncapacitated() {
        this.dog.removeAttributeModifier((Holder<Attribute>)Attributes.MOVEMENT_SPEED, HUNGER_MOVEMENT);
    }

    public void addHunger(float add) {
        float h0 = this.dog.getDogHunger();
        float h1 = h0 + add;
        int h2 = (int)(h1 - this.dog.getMaxHunger());
        if (h2 > 0) {
            this.saturation = Math.max(this.saturation, h2);
        }
        this.dog.setDogHunger(h0 + add);
    }
}

