/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.api.anim.DogAnimation;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.anim.DogPose;
import net.minecraft.world.entity.ai.goal.Goal;

public class DogCommonSitIdleGoal
extends Goal {
    private Dog dog;
    private int stopTick;

    public DogCommonSitIdleGoal(Dog dog) {
        this.dog = dog;
    }

    public boolean canUse() {
        if (!this.dog.isOrderedToSit()) {
            return false;
        }
        if (this.dog.getDogPose() != DogPose.SIT) {
            return false;
        }
        if (this.dog.getAnim() != DogAnimation.NONE) {
            return false;
        }
        if (!this.dog.canDoIdileAnim()) {
            return false;
        }
        if (!this.dog.onGround()) {
            return false;
        }
        return (double)this.dog.getRandom().nextFloat() < 0.02;
    }

    public boolean canContinueToUse() {
        if (!this.dog.isOrderedToSit()) {
            return false;
        }
        if (this.dog.getDogPose() != DogPose.SIT) {
            return false;
        }
        if (this.dog.getAnim() != DogAnimation.SIT_IDLE) {
            return false;
        }
        if (!this.dog.canContinueDoIdileAnim()) {
            return false;
        }
        if (!this.dog.onGround()) {
            return false;
        }
        return this.dog.tickCount < this.stopTick;
    }

    public void start() {
        DogAnimation currentAnimation = DogAnimation.SIT_IDLE;
        this.stopTick = this.dog.tickCount + currentAnimation.getLengthTicks();
        this.dog.setAnimForIdle(currentAnimation);
    }

    public void stop() {
        if (this.dog.getAnim() == DogAnimation.SIT_IDLE) {
            this.dog.setAnim(DogAnimation.NONE);
        }
    }
}

