/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.api.anim.DogAnimation;
import doggytalents.common.entity.Dog;
import java.util.EnumSet;
import net.minecraft.world.entity.ai.goal.Goal;

public class DogCommonStandIdleGoal
extends Goal {
    private Dog dog;
    private int stopTick;

    public DogCommonStandIdleGoal(Dog dog) {
        this.dog = dog;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (!this.dog.canDoIdileAnim()) {
            return false;
        }
        if (this.dog.getAnim() != DogAnimation.NONE) {
            return false;
        }
        if (this.dog.isOnFire()) {
            return false;
        }
        if (this.dog.isLowHunger()) {
            return false;
        }
        double use_chance = 0.02f;
        return (double)this.dog.getRandom().nextFloat() < use_chance;
    }

    public boolean canContinueToUse() {
        if (this.dog.isLowHunger()) {
            return false;
        }
        if (!this.dog.canContinueDoIdileAnim()) {
            return false;
        }
        return this.dog.tickCount < this.stopTick;
    }

    public void start() {
        DogAnimation currentAnimation = DogAnimation.STAND_IDLE_2;
        this.stopTick = this.dog.tickCount + currentAnimation.getLengthTicks();
        this.dog.setAnimForIdle(currentAnimation);
    }

    public void tick() {
    }

    public void stop() {
        if (this.dog.getAnim() == DogAnimation.STAND_IDLE_2) {
            this.dog.setAnim(DogAnimation.NONE);
        }
    }
}

