/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.common.entity.Dog;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;

public class DogLeapAtTargetGoal
extends Goal {
    private final Dog dog;
    private LivingEntity target;
    private final float yd;
    private final float START_LEAPING_AT_DIS_SQR = 2.0f;
    private final float DONT_LEAP_AT_DIS_SQR = 1.0f;

    public DogLeapAtTargetGoal(Dog p_25492_, float p_25493_) {
        this.dog = p_25492_;
        this.yd = p_25493_;
        this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (this.dog.isVehicle()) {
            return false;
        }
        this.target = this.dog.getTarget();
        if (this.target == null) {
            return false;
        }
        if (!this.target.onGround()) {
            return false;
        }
        double d0 = this.dog.distanceToSqr((Entity)this.target);
        if (d0 >= 1.0 && d0 <= 2.0) {
            if (!this.dog.onGround()) {
                return false;
            }
            if (this.dog.getRandom().nextInt(DogLeapAtTargetGoal.reducedTickDelay((int)5)) != 0) {
                return false;
            }
            BlockPos tpos = this.target.blockPosition();
            if (WalkNodeEvaluator.getPathTypeStatic((Mob)this.dog, (BlockPos)tpos.mutable()) != PathType.WALKABLE) {
                return false;
            }
            Vec3 v0 = new Vec3(this.target.getX() - this.dog.getX(), 0.0, this.target.getZ() - this.dog.getZ()).normalize();
            BlockPos bp1 = this.dog.blockPosition();
            Vec3 v1 = new Vec3((double)bp1.getX(), (double)bp1.getY(), (double)bp1.getZ());
            for (int i = 1; i <= 2; ++i) {
                v1 = v1.add(v0);
                if (WalkNodeEvaluator.getPathTypeStatic((Mob)this.dog, (BlockPos)new BlockPos(Mth.floor((double)v1.x), Mth.floor((double)v1.y), Mth.floor((double)v1.z)).mutable()) == PathType.WALKABLE) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return !this.dog.onGround();
    }

    public void start() {
        Vec3 vec3 = this.dog.getDeltaMovement();
        Vec3 vec31 = new Vec3(this.target.getX() - this.dog.getX(), 0.0, this.target.getZ() - this.dog.getZ());
        if (vec31.lengthSqr() > 1.0E-7) {
            vec31 = vec31.normalize().scale(0.4).add(vec3.scale(0.2));
        }
        this.dog.setDeltaMovement(vec31.x, this.yd, vec31.z);
    }
}

