/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai.nav;

import doggytalents.common.entity.Dog;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class DogNodeEvaluator
extends WalkNodeEvaluator {
    private final Supplier<Dog> dogGetter;

    public DogNodeEvaluator(Supplier<Dog> dogGetter) {
        this.dogGetter = dogGetter;
    }

    protected double getFloorLevel(BlockPos pos) {
        Dog dog = this.dogGetter.get();
        if (dog.fireImmune() && dog.level().getFluidState(pos).is(FluidTags.LAVA)) {
            return pos.getY();
        }
        return super.getFloorLevel(pos);
    }

    @Nullable
    protected Node findAcceptedNode(int x, int y, int z, int floorLevel, double maxUpStep, Direction dir, PathType centerType) {
        if (centerType == PathType.DOOR_WOOD_CLOSED && this.dogGetter.get().canDogPassGate()) {
            centerType = PathType.WALKABLE;
        }
        return super.findAcceptedNode(x, y, z, floorLevel, maxUpStep, dir, centerType);
    }

    public PathType getPathTypeOfMob(PathfindingContext context, int x, int y, int z, Mob mob) {
        BlockState state;
        PathType retType = super.getPathTypeOfMob(context, x, y, z, mob);
        Dog dog = this.dogGetter.get();
        if (retType == PathType.FENCE && dog.canDogPassGate() && (state = dog.level().getBlockState(new BlockPos(x, y, z))).getBlock() instanceof FenceGateBlock) {
            retType = PathType.WALKABLE;
        }
        if (retType == PathType.DANGER_FIRE && !dog.isInLava()) {
            BlockPos check_pos = new BlockPos(x, y - 1, z);
            BlockState state2 = dog.level().getBlockState(check_pos);
            if (!state2.isCollisionShapeFullBlock((BlockGetter)dog.level(), check_pos)) {
                retType = PathType.DAMAGE_FIRE;
            }
        }
        return retType;
    }

    public Node getBlockedNode(int x, int y, int z) {
        Node ret = new Node(x, y, z);
        ret.type = PathType.OPEN;
        ret.costMalus = -1.0f;
        return ret;
    }

    protected boolean isNeighborValid(@Nullable Node neighbor, Node center) {
        if (neighbor != null && neighbor.type == PathType.OPEN) {
            return false;
        }
        return super.isNeighborValid(neighbor, center);
    }

    public static PathType dogGetPathTypeFromState(BlockGetter getter, BlockPos pos) {
        return WalkNodeEvaluator.getPathTypeFromState((BlockGetter)getter, (BlockPos)pos);
    }
}

