/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.misc;

import java.util.List;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;

public abstract class BaseDogPlushie
extends Entity {
    public BaseDogPlushie(EntityType<?> type, Level level) {
        super(type, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        super.tick();
        if (!this.isNoGravity()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.04, 0.0));
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        this.setDeltaMovement(this.getDeltaMovement().scale(0.7));
        this.pushOtherPlush();
    }

    public boolean isPushable() {
        return true;
    }

    public boolean isInvulnerableTo(DamageSource source) {
        if (this.isRemoved()) {
            return true;
        }
        if (source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return false;
        }
        if (source.is(DamageTypeTags.IS_FIRE)) {
            return false;
        }
        return !(source.getDirectEntity() instanceof Player);
    }

    public boolean fireImmune() {
        return false;
    }

    public boolean isEffectiveAi() {
        return false;
    }

    public boolean isPickable() {
        return true;
    }

    public boolean canBeHitByProjectile() {
        return false;
    }

    public boolean hurtServer(ServerLevel level, DamageSource source, float damage) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        this.mayDropSelf(source);
        this.discard();
        return true;
    }

    private void mayDropSelf(DamageSource source) {
        Entity entity = source.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.getAbilities().instabuild) {
            return;
        }
        ItemStack drop = this.getDogPlusieItemDrop();
        if (!drop.isEmpty()) {
            this.spawnAtLocation((ServerLevel)this.level(), drop);
        }
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        Item item = stack.getItem();
        if (item == Items.TORCH) {
            if (!this.level().isClientSide && player.isShiftKeyDown()) {
                this.setYRot(this.getYRot() + 45.0f);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    private void pushOtherPlush() {
        if (this.level().isClientSide) {
            return;
        }
        List list = this.level().getEntities(EntityTypeTest.forClass(BaseDogPlushie.class), this.getBoundingBox(), e -> true);
        for (BaseDogPlushie e2 : list) {
            e2.push(this);
        }
    }

    public abstract ItemStack getDogPlusieItemDrop();
}

