/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.serializers;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class Dimension2BlockPosMap {
    private final Map<ResourceKey<Level>, BlockPos> map = Maps.newHashMap();

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int size() {
        return this.map.size();
    }

    public Dimension2BlockPosMap copy() {
        Dimension2BlockPosMap ret = new Dimension2BlockPosMap();
        ret.map.putAll(this.map);
        return ret;
    }

    public Iterable<Map.Entry<ResourceKey<Level>, BlockPos>> entrySet() {
        return this.map.entrySet();
    }

    public Optional<BlockPos> get(ResourceKey<Level> dimension) {
        return Optional.ofNullable(this.map.get(dimension));
    }

    public void put(ResourceKey<Level> dimension, BlockPos pos) {
        if (dimension == null) {
            return;
        }
        if (pos == null) {
            this.map.remove(dimension);
        } else {
            this.map.put(dimension, pos);
        }
    }

    public Dimension2BlockPosMap copyAndSet(ResourceKey<Level> dimension, Optional<BlockPos> pos) {
        if (dimension == null || pos == null) {
            return this;
        }
        Dimension2BlockPosMap ret = this.copy();
        ret.put(dimension, pos.orElse(null));
        return ret;
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        if (!(obj instanceof Dimension2BlockPosMap)) {
            return false;
        }
        Dimension2BlockPosMap other = (Dimension2BlockPosMap)obj;
        return this.map.equals(other.map);
    }

    public String toString() {
        return this.map.toString();
    }
}

