/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.inventory.container;

import doggytalents.DoggyBlocks;
import doggytalents.DoggyContainerTypes;
import doggytalents.common.block.tileentity.FoodBowlTileEntity;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class FoodBowlContainer
extends AbstractContainerMenu {
    private FoodBowlTileEntity tileEntity;

    public FoodBowlContainer(int windowId, Level world, BlockPos pos, Inventory playerInventory, Player player) {
        super(DoggyContainerTypes.FOOD_BOWL.get(), windowId);
        this.tileEntity = this.getFoodBow(world, pos).orElse(null);
        if (this.tileEntity == null) {
            return;
        }
        ItemStackHandler inventory = this.tileEntity.getInventory();
        for (int i = 0; i < 1; ++i) {
            for (int l = 0; l < 5; ++l) {
                this.addSlot((Slot)new SlotItemHandler((IItemHandler)inventory, l + i * 9, 44 + l * 18, 22 + i * 18));
            }
        }
        for (int j = 0; j < 3; ++j) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.addSlot(new Slot((Container)playerInventory, i1 + j * 9 + 9, 8 + i1 * 18, 45 + j * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)playerInventory, k, 8 + k * 18, 103));
        }
    }

    public boolean stillValid(Player player) {
        return FoodBowlContainer.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.tileEntity.getLevel(), (BlockPos)this.tileEntity.getBlockPos()), (Player)player, (Block)((Block)DoggyBlocks.FOOD_BOWL.get()));
    }

    public ItemStack quickMoveStack(Player player, int i) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(i);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (i < 5 ? !this.moveItemStackTo(itemstack1, 5, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, 5, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
        }
        return itemstack;
    }

    private Optional<FoodBowlTileEntity> getFoodBow(Level level, BlockPos pos) {
        BlockEntity tileEntity = level.getBlockEntity(pos);
        if (tileEntity instanceof FoodBowlTileEntity) {
            FoodBowlTileEntity foodBow = (FoodBowlTileEntity)tileEntity;
            return Optional.of(foodBow);
        }
        return Optional.empty();
    }
}

