/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.api.inferface.AbstractDog;
import doggytalents.common.backward_imitate.DogFoodProperties_21_3;
import doggytalents.common.item.DogEddibleItem;
import java.util.function.Function;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public abstract class DogEddibleBowlFoodItem
extends DogEddibleItem {
    public DogEddibleBowlFoodItem(Item.Properties itemProps, DogFoodProperties_21_3 foodProps) {
        super(itemProps.craftRemainder(Items.BOWL), foodProps);
    }

    public DogEddibleBowlFoodItem(Item.Properties itemProps, Function<DogFoodProperties_21_3, DogFoodProperties_21_3> propsCreator) {
        this(itemProps, propsCreator.apply(new DogFoodProperties_21_3()));
    }

    public DogEddibleBowlFoodItem(Item.Properties itemProps, Function<Item.Properties, Item.Properties> itemPropsCreator, Function<DogFoodProperties_21_3, DogFoodProperties_21_3> propsCreator) {
        this(itemPropsCreator.apply(itemProps), propsCreator.apply(new DogFoodProperties_21_3()));
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity user) {
        boolean creativeUse;
        ItemStack returnStack = super.finishUsingItem(stack, level, user);
        boolean bl = creativeUse = user instanceof Player && ((Player)user).getAbilities().instabuild;
        if (creativeUse) {
            return returnStack;
        }
        if (returnStack.isEmpty()) {
            return new ItemStack((ItemLike)Items.BOWL);
        }
        if (!(user instanceof Player)) {
            return returnStack;
        }
        Player player = (Player)user;
        if (player.level().isClientSide) {
            return returnStack;
        }
        ItemStack bonusReturnStack = new ItemStack((ItemLike)Items.BOWL);
        Inventory inv = player.getInventory();
        int freeSlot = inv.getFreeSlot();
        if (freeSlot >= 0) {
            inv.add(bonusReturnStack);
        } else {
            player.spawnAtLocation((ServerLevel)player.level(), bonusReturnStack);
        }
        return returnStack;
    }

    @Override
    public ItemStack getReturnStackAfterDogConsume(ItemStack useStack, AbstractDog dog) {
        return new ItemStack((ItemLike)Items.BOWL);
    }
}

