/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.client.screen.DogNewInfoScreen.store.slice.ActiveTabSlice;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.DogGroupsManager;
import doggytalents.common.network.DTNNetworkHandler;
import doggytalents.common.network.IPacket;
import doggytalents.common.network.PacketDistributor;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.DogGroupsData;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class DogGroupPackets {

    public static class UPDATE
    implements IPacket<DogGroupsData.UPDATE> {
        @Override
        public void encode(DogGroupsData.UPDATE data, FriendlyByteBuf buf) {
            buf.writeInt(data.dogId);
            buf.writeInt(data.groups.size());
            for (DogGroupsManager.DogGroup group : data.groups) {
                buf.writeUtf(group.name, 16);
                buf.writeInt(group.color);
            }
        }

        @Override
        public DogGroupsData.UPDATE decode(FriendlyByteBuf buf) {
            int id = buf.readInt();
            int size = buf.readInt();
            ArrayList<DogGroupsManager.DogGroup> groups = new ArrayList<DogGroupsManager.DogGroup>(size);
            for (int i = 0; i < size; ++i) {
                String group = buf.readUtf(16);
                int color = buf.readInt();
                groups.add(new DogGroupsManager.DogGroup(group, color));
            }
            return new DogGroupsData.UPDATE(id, groups);
        }

        @Override
        public void handle(DogGroupsData.UPDATE data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (!((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).isClientRecipent()) {
                    return;
                }
                Minecraft mc = Minecraft.getInstance();
                ClientLevel level = mc.level;
                if (level == null) {
                    return;
                }
                Entity e = level.getEntity(data.dogId);
                if (!(e instanceof Dog)) {
                    return;
                }
                Dog d = (Dog)e;
                DogGroupsManager groups = d.getGroups();
                groups.clear();
                for (DogGroupsManager.DogGroup group : data.groups) {
                    groups.add(group);
                }
                ActiveTabSlice.dispatchGroupUpdates();
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static class FETCH_REQUEST
    extends DogPacket<DogGroupsData.FETCH_REQUEST> {
        @Override
        public DogGroupsData.FETCH_REQUEST decode(FriendlyByteBuf buf) {
            return new DogGroupsData.FETCH_REQUEST(buf.readInt());
        }

        @Override
        public void handleDog(Dog dogIn, DogGroupsData.FETCH_REQUEST data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
            if (dogIn.level().isClientSide) {
                return;
            }
            DogGroupsManager groups = dogIn.getGroups();
            ServerPlayer sender = ctx.get().getSender();
            PacketHandler.send(PacketDistributor.PLAYER.with(() -> sender), new DogGroupsData.UPDATE(dogIn.getId(), new ArrayList<DogGroupsManager.DogGroup>(groups.getGroupsReadOnly())));
        }
    }

    public static class EDIT
    extends DogPacket<DogGroupsData.EDIT> {
        @Override
        public void encode(DogGroupsData.EDIT data, FriendlyByteBuf buf) {
            super.encode(data, buf);
            buf.writeBoolean(data.add);
            buf.writeUtf(data.group.name, 16);
            buf.writeInt(data.group.color);
        }

        @Override
        public DogGroupsData.EDIT decode(FriendlyByteBuf buf) {
            int id = buf.readInt();
            boolean add = buf.readBoolean();
            String group = buf.readUtf(16);
            int color = buf.readInt();
            return new DogGroupsData.EDIT(id, new DogGroupsManager.DogGroup(group, color), add);
        }

        @Override
        public void handleDog(Dog dogIn, DogGroupsData.EDIT data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
            if (dogIn.level().isClientSide) {
                return;
            }
            ServerPlayer sender = ctx.get().getSender();
            if (!dogIn.canInteract((LivingEntity)sender)) {
                return;
            }
            DogGroupsManager groups = dogIn.getGroups();
            boolean update = false;
            update = data.add ? groups.add(data.group) : groups.remove(data.group);
            if (update) {
                PacketHandler.send(PacketDistributor.PLAYER.with(() -> sender), new DogGroupsData.UPDATE(dogIn.getId(), new ArrayList<DogGroupsManager.DogGroup>(groups.getGroupsReadOnly())));
            }
        }
    }
}

