/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.DoggyItems;
import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.common.entity.Dog;
import doggytalents.common.item.AmnesiaBoneItem;
import doggytalents.common.network.DTNNetworkHandler;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.DogMigrateOwnerData;
import doggytalents.common.util.ItemUtil;
import doggytalents.common.util.PlayerUtil;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class DogMigrateOwnerPacket
extends DogPacket<DogMigrateOwnerData> {
    @Override
    public void encode(DogMigrateOwnerData data, FriendlyByteBuf buf) {
        buf.writeInt(data.entityId);
        buf.writeBoolean(data.confirmed);
    }

    @Override
    public DogMigrateOwnerData decode(FriendlyByteBuf buf) {
        int id = buf.readInt();
        boolean confirmed = buf.readBoolean();
        return new DogMigrateOwnerData(id, confirmed);
    }

    @Override
    public void handleDog(Dog dog, DogMigrateOwnerData data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
        ServerPlayer sender = ctx.get().getSender();
        ItemStack stack = sender.getMainHandItem();
        if (stack.getItem() != DoggyItems.AMNESIA_BONE.get()) {
            return;
        }
        if (PlayerUtil.isOnCooldown((Player)sender, DoggyItems.AMNESIA_BONE.get())) {
            return;
        }
        UUID ownerUUID = dog.getOwnerUUID();
        if (ownerUUID == null) {
            return;
        }
        if (!ownerUUID.equals(sender.getUUID())) {
            return;
        }
        CompoundTag_1_21_5 tag = ItemUtil.getTag(stack);
        if (tag == null) {
            return;
        }
        if (!tag.hasUUID("request_uuid")) {
            ItemUtil.modifyTag(stack, to_modify -> to_modify.remove("request_str"));
            return;
        }
        UUID uuid = tag.getUUID("request_uuid");
        ItemUtil.modifyTag(stack, to_modify -> {
            to_modify.remove("request_uuid");
            to_modify.remove("request_str");
        });
        if (ownerUUID.equals(uuid)) {
            return;
        }
        Player requester = dog.level().getPlayerByUUID(uuid);
        if (requester == null) {
            return;
        }
        if (!data.confirmed) {
            PlayerUtil.sendSystemMessage((LivingEntity)requester, (Component)Component.translatable((String)"item.doggytalents.amnesia_bone.migrate_owner.reject", (Object[])new Object[]{dog.getName().getString()}).withStyle(ChatFormatting.RED));
            return;
        }
        if (sender.experienceLevel < AmnesiaBoneItem.getMigrateOwnerXPCost()) {
            return;
        }
        dog.migrateOwner(uuid);
        sender.giveExperienceLevels(-AmnesiaBoneItem.getMigrateOwnerXPCost());
        PlayerUtil.addCooldown((Player)sender, DoggyItems.AMNESIA_BONE.get(), 60);
        int usedTime = tag.getInt("amnesia_bone_used_time");
        if (++usedTime >= AmnesiaBoneItem.getUseCap()) {
            stack.shrink(1);
            sender.onEquippedItemBroken(stack.getItem(), EquipmentSlot.MAINHAND);
        }
        tag.putInt("amnesia_bone_used_time", usedTime);
        PlayerUtil.sendSystemMessage((LivingEntity)requester, (Component)Component.translatable((String)"item.doggytalents.amnesia_bone.migrate_owner.confirmed", (Object[])new Object[]{dog.getName().getString(), dog.getGenderPronoun()}));
        ItemUtil.putTag(stack, tag);
    }
}

