/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.api.backward_imitate.DogInteractionResult;
import doggytalents.api.backward_imitate.InteractionResultHolder;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogFoodHandler;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.util.ItemUtil;
import net.minecraft.core.component.DataComponents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class HappyEaterTalent
extends TalentInstance
implements IDogFoodHandler {
    public HappyEaterTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public InteractionResultHolder<Float> setDogHunger(AbstractDog dogIn, float hunger, float diff) {
        return InteractionResultHolder.success(Float.valueOf(hunger += diff / 10.0f * (float)this.level()));
    }

    @Override
    public boolean isFood(ItemStack stackIn) {
        if (this.level() < 2) {
            return false;
        }
        if (!ItemUtil.isEddible(stackIn)) {
            return false;
        }
        return stackIn.is(ItemTags.FISHES);
    }

    @Override
    public boolean canConsume(AbstractDog dogIn, ItemStack stackIn, Entity entityIn) {
        if (dogIn.isDefeated()) {
            return false;
        }
        Item item = stackIn.getItem();
        return this.level() >= 2 && ItemUtil.isEddible(stackIn) && stackIn.is(ItemTags.FISHES);
    }

    @Override
    public DogInteractionResult consume(AbstractDog dogIn, ItemStack stackIn, Entity entityIn) {
        if (dogIn.level().isClientSide) {
            return DogInteractionResult.SUCCESS;
        }
        Item item = stackIn.getItem();
        FoodProperties food_comp = (FoodProperties)stackIn.getOrDefault(DataComponents.FOOD, null);
        if (this.level() >= 2 && food_comp != null && stackIn.is(ItemTags.FISHES)) {
            dogIn.addHunger(food_comp.nutrition() * 5);
            dogIn.consumeItemFromStack(entityIn, stackIn);
            return DogInteractionResult.SUCCESS;
        }
        return DogInteractionResult.FAIL;
    }
}

