/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.DoggyItems;
import doggytalents.api.feature.DogMode;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.backward_imitate.EntityUtil_1_21_5;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.util.DogUtil;
import doggytalents.common.util.EntityUtil;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.phys.Vec3;

public class ShepherdDogTalent
extends TalentInstance {
    private List<Animal> targets = List.of();
    private static final int SEARCH_RANGE = 12;
    private static final int SEARCH_RANGE_EXT = 16;
    private static final int VALID_FOLLOWING_DISTANCE = 400;
    private int tickTillSearch;

    public ShepherdDogTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void init(AbstractDog dogIn) {
    }

    @Override
    public void livingTick(AbstractDog abstractDog) {
        if (abstractDog.level().isClientSide) {
            return;
        }
        if (!(abstractDog instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)abstractDog;
        LivingEntity owner = dog.getOwner();
        if (owner == null) {
            return;
        }
        if (dog.readyForNonTrivialAction() && dog.getMode() == DogMode.DOCILE && !dog.isOrderedToSit() && --this.tickTillSearch <= 0) {
            this.tickTillSearch = 10;
            this.refreshShepherdTargets(dog, 12);
            if (!this.targets.isEmpty() && EntityUtil.isHolding(owner, DoggyItems.WHISTLE.get(), nbt -> nbt.contains("mode") && nbt.getInt("mode") == 4)) {
                if (!this.triggerShepherdAction(dog, owner)) {
                    this.targets = List.of();
                }
            } else {
                this.targets = List.of();
            }
        }
    }

    private boolean triggerShepherdAction(Dog dog, LivingEntity owner) {
        if (owner instanceof ServerPlayer) {
            ServerPlayer sP = (ServerPlayer)owner;
            return dog.triggerAction(new ShepherdAction(dog, sP, this));
        }
        return false;
    }

    public static int getMaxFollowers(int level) {
        switch (level) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 8;
            }
            case 5: {
                return 16;
            }
        }
        return 0;
    }

    public boolean isValidAnimal(Dog dog, Animal animal) {
        if (!animal.isAlive()) {
            return false;
        }
        if (animal.isInvisible()) {
            return false;
        }
        if (animal instanceof TamableAnimal) {
            return false;
        }
        if (animal.distanceToSqr((Entity)dog) > 400.0) {
            return false;
        }
        return animal.getSensing().hasLineOfSight((Entity)dog);
    }

    public void refreshShepherdTargets(Dog dog, int searchRange) {
        this.targets = dog.level().getEntitiesOfClass(Animal.class, dog.getBoundingBox().inflate((double)searchRange, 4.0, (double)searchRange), e -> this.isValidAnimal(dog, (Animal)e));
        if (this.targets.isEmpty()) {
            return;
        }
        Collections.sort(this.targets, new EntityUtil.Sorter((Entity)dog));
        int followCap = ShepherdDogTalent.getMaxFollowers(this.level());
        if (followCap < this.targets.size()) {
            this.targets = this.targets.subList(0, Math.min(followCap, this.targets.size()));
        }
    }

    private static class ShepherdAction
    extends TriggerableAction {
        private static final int LOOK_OWNER_INTERVAL = 20;
        private final ShepherdDogTalent talentInst;
        @Nonnull
        private ServerPlayer owner;
        private int tickTillPathRecalc;
        private int tickTillLook;

        public ShepherdAction(Dog dog, @Nonnull ServerPlayer owner, ShepherdDogTalent talentInst) {
            super(dog, false, true);
            this.talentInst = talentInst;
            this.owner = owner;
        }

        @Override
        public void onStart() {
            this.tickTillPathRecalc = 0;
            this.tickTillLook = 0;
        }

        @Override
        public void tick() {
            boolean update;
            if (this.dog.getMode() != DogMode.DOCILE) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (!EntityUtil.isHolding((LivingEntity)this.owner, DoggyItems.WHISTLE.get(), nbt -> nbt.contains("mode") && nbt.getInt("mode") == 4)) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            boolean bl = update = --this.tickTillPathRecalc <= 0;
            if (update) {
                this.tickTillPathRecalc = 20;
            }
            if (update) {
                this.talentInst.refreshShepherdTargets(this.dog, 16);
            }
            if (this.talentInst.targets.isEmpty()) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (--this.tickTillLook <= 0) {
                this.tickTillLook = 20;
                this.dog.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)this.dog.getMaxHeadXRot());
            }
            if (update) {
                this.herdTargets();
            }
        }

        private void herdTargets() {
            boolean teleport = this.owner.distanceToSqr((Entity)this.talentInst.targets.get(0)) > 256.0;
            for (Animal target : this.talentInst.targets) {
                double distanceAway = target.distanceToSqr((Entity)this.owner);
                target.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)target.getMaxHeadXRot());
                if (teleport) {
                    if (target.isLeashed() || target.isPassenger()) continue;
                    EntityUtil.tryToTeleportNearEntity((Mob)target, target.getNavigation(), (LivingEntity)this.owner, 4);
                    continue;
                }
                if (distanceAway >= 25.0) {
                    if (target.getNavigation().moveTo((Entity)this.owner, 1.2) || target.isLeashed() || target.isPassenger() || !(distanceAway >= 400.0)) continue;
                    EntityUtil.tryToTeleportNearEntity((Mob)target, target.getNavigation(), (LivingEntity)this.owner, 4);
                    continue;
                }
                target.getNavigation().stop();
            }
            this.moveInTheMiddleOfHerdingGroup(teleport);
            if (this.dog.distanceToSqr((Entity)this.owner) > 1600.0) {
                DogUtil.guessAndTryToTeleportToOwner(this.dog, (LivingEntity)this.owner, 2);
            }
            if (this.dog.getRandom().nextFloat() < 0.15f) {
                this.dog.playSound(EntityUtil_1_21_5.legacyWolfAmbientSound(this.dog), this.dog.getSoundVolume() + 1.0f, (this.dog.getRandom().nextFloat() - this.dog.getRandom().nextFloat()) * 0.1f + 0.9f);
            }
        }

        private void moveInTheMiddleOfHerdingGroup(boolean teleport) {
            Vec3 avgPosVec = Vec3.ZERO;
            for (Animal target : this.talentInst.targets) {
                avgPosVec = avgPosVec.add(target.position());
            }
            avgPosVec = avgPosVec.scale(1.0 / (double)this.talentInst.targets.size());
            double d_avgPosX_ownerX = avgPosVec.x - this.owner.getX();
            double d_avgPosZ_ownerZ = avgPosVec.z - this.owner.getZ();
            double size = Math.sqrt(d_avgPosX_ownerX * d_avgPosX_ownerX + d_avgPosZ_ownerZ * d_avgPosZ_ownerZ);
            double tpPosX = avgPosVec.x + d_avgPosX_ownerX / size * (double)(2 + this.talentInst.targets.size() / 16);
            double tpPosZ = avgPosVec.z + d_avgPosZ_ownerZ / size * (double)(2 + this.talentInst.targets.size() / 16);
            if (teleport) {
                EntityUtil.tryToTeleportNearEntity((Mob)this.dog, this.dog.getNavigation(), new BlockPos(Mth.floor((double)tpPosX), Mth.floor((double)this.dog.getY()), Mth.floor((double)tpPosZ)), 1);
            }
            this.dog.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)this.dog.getMaxHeadXRot());
            if (!this.dog.getNavigation().moveTo(tpPosX, this.owner.getBoundingBox().minY, tpPosZ, 1.0) && this.dog.distanceToSqr(tpPosX, this.owner.getBoundingBox().minY, tpPosZ) > 144.0 && !this.dog.isLeashed() && !this.dog.isPassenger()) {
                EntityUtil.tryToTeleportNearEntity((Mob)this.dog, this.dog.getNavigation(), new BlockPos(Mth.floor((double)tpPosX), Mth.floor((double)this.dog.getY()), Mth.floor((double)tpPosZ)), 4);
            }
        }

        @Override
        public void onStop() {
            this.talentInst.targets = List.of();
        }

        @Override
        public boolean canOverrideSit() {
            return false;
        }
    }
}

