/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.DoggyAttributes;
import doggytalents.DoggyTalents;
import doggytalents.api.backward_imitate.DogInteractionResult;
import doggytalents.api.backward_imitate.InteractionResultHolder;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.PlayerUtil;
import doggytalents.common.util.Util;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class WolfMountTalent
extends TalentInstance {
    private static final ResourceLocation WOLF_MOUNT_JUMP = Util.getResource("wolf_mount_jump");
    private int lastClickTick;

    public WolfMountTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void init(AbstractDog dogIn) {
        dogIn.setAttributeModifier((Holder<Attribute>)DoggyAttributes.JUMP_POWER, WOLF_MOUNT_JUMP, this::createSpeedModifier);
    }

    @Override
    public void set(AbstractDog dogIn, int level) {
        dogIn.setAttributeModifier((Holder<Attribute>)DoggyAttributes.JUMP_POWER, WOLF_MOUNT_JUMP, this::createSpeedModifier);
    }

    @Override
    public void remove(AbstractDog dog) {
        dog.removeAttributeModifier((Holder<Attribute>)DoggyAttributes.JUMP_POWER, WOLF_MOUNT_JUMP);
    }

    public AttributeModifier createSpeedModifier(AbstractDog dogIn, ResourceLocation uuidIn) {
        if (this.level() > 0) {
            double speed = 0.06 * (double)this.level();
            if (this.level() >= 5) {
                speed += 0.04;
            }
            return new AttributeModifier(uuidIn, speed, AttributeModifier.Operation.ADD_VALUE);
        }
        return null;
    }

    @Override
    public DogInteractionResult processInteract(AbstractDog dog, Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!stack.isEmpty()) {
            return DogInteractionResult.PASS;
        }
        if (this.level() <= 0) {
            return DogInteractionResult.PASS;
        }
        if (dog.isVehicle() || dog.isPassenger()) {
            return DogInteractionResult.PASS;
        }
        if (!dog.canInteract((LivingEntity)player)) {
            return DogInteractionResult.PASS;
        }
        if (player.isPassenger()) {
            return DogInteractionResult.PASS;
        }
        int lastClickTick0 = this.lastClickTick;
        this.lastClickTick = player.tickCount;
        if (this.lastClickTick - lastClickTick0 > 5) {
            return DogInteractionResult.PASS;
        }
        if (!dog.level().isClientSide) {
            dog.setOrderedToSit(false);
            player.setYRot(dog.getYRot());
            player.setXRot(dog.getXRot());
            player.startRiding((Entity)dog);
        }
        return DogInteractionResult.SUCCESS;
    }

    @Override
    public void livingTick(AbstractDog dog) {
        if (dog.isVehicle() && dog.getDogHunger() < 1.0f) {
            LivingEntity control = dog.getControllingPassenger();
            if (control != null) {
                PlayerUtil.sendSystemMessage(control, (Component)Component.translatable((String)"talent.doggytalents.wolf_mount.exhausted", (Object[])new Object[]{dog.getName()}));
            }
            dog.ejectPassengers();
        }
    }

    @Override
    public InteractionResultHolder<Float> hungerTick(AbstractDog dogIn, float hungerTick_add) {
        if (dogIn.getControllingPassenger() != null) {
            return InteractionResultHolder.success(Float.valueOf(hungerTick_add += this.level() < 5 ? 3.0f : 1.0f));
        }
        return InteractionResultHolder.pass(Float.valueOf(hungerTick_add));
    }

    @Override
    public InteractionResultHolder<Float> calculateFallDistance(AbstractDog dogIn, float distance) {
        if (this.level() >= 5) {
            return InteractionResultHolder.success(Float.valueOf(distance - 1.0f));
        }
        return InteractionResultHolder.pass(Float.valueOf(0.0f));
    }

    @Override
    public DogInteractionResult shouldSkipAttackFrom(AbstractDog dogIn, Entity entity) {
        return dogIn.isPassengerOfSameVehicle(entity) ? DogInteractionResult.SUCCESS : DogInteractionResult.PASS;
    }

    public static boolean isValidCarryMeDog(Dog dog) {
        if (!dog.isAlive()) {
            return false;
        }
        if (dog.isVehicle() || dog.isPassenger()) {
            return false;
        }
        return dog.getDogLevel(DoggyTalents.WOLF_MOUNT) > 0;
    }

    public static boolean isValidCarryMeTarget(LivingEntity target) {
        if (!(target instanceof Player)) {
            return false;
        }
        if (!target.isAlive() || target.isSpectator()) {
            return false;
        }
        return !target.isVehicle() && !target.isPassenger();
    }
}

