/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util;

import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.common.backward_imitate.EntityUtil_1_21_5;
import doggytalents.common.util.ItemUtil;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;

public class EntityUtil {
    public static double getFollowRange(LivingEntity entityIn) {
        AttributeInstance rangeAttribute = entityIn.getAttribute(Attributes.FOLLOW_RANGE);
        return rangeAttribute == null ? 16.0 : rangeAttribute.getValue();
    }

    public static boolean tryToTeleportNearEntity(Mob entityIn, PathNavigation navigator, LivingEntity target, int radius) {
        return EntityUtil.tryToTeleportNearEntity(entityIn, navigator, target.blockPosition(), radius);
    }

    public static boolean tryToTeleportNearEntity(Mob entityIn, PathNavigation navigator, BlockPos targetPos, int radius) {
        for (int i = 0; i < 10; ++i) {
            int j = EntityUtil.getRandomNumber((LivingEntity)entityIn, -radius, radius);
            int k = EntityUtil.getRandomNumber((LivingEntity)entityIn, -1, 1);
            int l = EntityUtil.getRandomNumber((LivingEntity)entityIn, -radius, radius);
            boolean flag = EntityUtil.tryToTeleportToLocation(entityIn, navigator, targetPos, targetPos.getX() + j, targetPos.getY() + k, targetPos.getZ() + l);
            if (!flag) continue;
            return true;
        }
        return false;
    }

    public static boolean tryToTeleportToLocation(Mob entityIn, PathNavigation navigator, BlockPos targetPos, int x, int y, int z) {
        if ((double)Math.abs(x - targetPos.getX()) < 2.0 && (double)Math.abs(z - targetPos.getZ()) < 2.0) {
            return false;
        }
        if (!EntityUtil.isTeleportFriendlyBlock(entityIn, new BlockPos(x, y, z), false)) {
            return false;
        }
        entityIn.snapTo((double)((float)x + 0.5f), (double)y, (double)((float)z + 0.5f), entityIn.getYRot(), entityIn.getXRot());
        navigator.stop();
        return true;
    }

    private static boolean isTeleportFriendlyBlock(Mob entityIn, BlockPos pos, boolean teleportToLeaves) {
        PathType pathnodetype = WalkNodeEvaluator.getPathTypeStatic((Mob)entityIn, (BlockPos)pos.mutable());
        if (pathnodetype != PathType.WALKABLE) {
            return false;
        }
        BlockState blockstate = entityIn.level().getBlockState(pos.below());
        if (!teleportToLeaves && blockstate.getBlock() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockpos = pos.subtract((Vec3i)entityIn.blockPosition());
        return entityIn.level().noCollision((Entity)entityIn, entityIn.getBoundingBox().move(blockpos));
    }

    public static int getRandomNumber(LivingEntity entityIn, int minIn, int maxIn) {
        return entityIn.getRandom().nextInt(maxIn - minIn + 1) + minIn;
    }

    public static boolean isHolding(@Nullable LivingEntity entity, Item item, Predicate<CompoundTag_1_21_5> nbtPredicate) {
        return EntityUtil.isHolding(entity, (ItemStack stack) -> stack.getItem() == item && ItemUtil.hasTag(stack) && nbtPredicate.test(ItemUtil.getTag(stack)));
    }

    public static boolean isHolding(@Nullable LivingEntity entity, Item item) {
        return EntityUtil.isHolding(entity, (ItemStack stack) -> stack.getItem() == item);
    }

    public static boolean isHolding(@Nullable LivingEntity entity, Predicate<ItemStack> matcher) {
        if (entity == null) {
            return false;
        }
        for (ItemStack stack : EntityUtil_1_21_5.getHandSlot(entity)) {
            if (!matcher.test(stack)) continue;
            return true;
        }
        return false;
    }

    public static <T extends Entity> T getClosestTo(Entity center, Iterable<T> entities) {
        return EntityUtil.getClosestTo(center.position(), entities);
    }

    public static <T extends Entity> T getClosestTo(Vec3 posVec, Iterable<T> entities) {
        double smallestDist = Double.MAX_VALUE;
        Entity closest = null;
        for (Entity entity : entities) {
            double distance = posVec.distanceToSqr(entity.position());
            if (!(distance < smallestDist)) continue;
            closest = entity;
            smallestDist = distance;
        }
        return (T)closest;
    }

    public static void setSecondsOnFire(Entity e, int second) {
        e.setRemainingFireTicks(second * 20);
    }

    public static <T extends Entity> Optional<T> getRandomEntityAround(LivingEntity entity, Class<T> entity_class, int radius_xz, int radius_y, Predicate<T> entity_pred) {
        Predicate<Entity> compound_pred;
        AABB bb;
        Level level = entity.level();
        List list = level.getEntitiesOfClass(entity_class, bb = entity.getBoundingBox().inflate((double)radius_xz, (double)radius_y, (double)radius_xz), compound_pred = filter -> filter != entity && entity_pred.test(filter));
        if (list.isEmpty()) {
            return Optional.empty();
        }
        if (list.size() == 1) {
            return Optional.of((Entity)list.get(0));
        }
        RandomSource random = entity.getRandom();
        int r = random.nextInt(list.size());
        return Optional.of((Entity)list.get(r));
    }

    public static boolean allHandEmpty(LivingEntity entity) {
        ItemStack mainhand = entity.getMainHandItem();
        if (mainhand != null && !mainhand.isEmpty()) {
            return false;
        }
        ItemStack offhand = entity.getOffhandItem();
        return offhand == null || offhand.isEmpty();
    }

    public static boolean isWaterBreathingEntity(LivingEntity entity) {
        return !entity.canDrownInFluidType((FluidType)NeoForgeMod.WATER_TYPE.value());
    }

    public static class Sorter
    implements Comparator<Entity> {
        private final Vec3 vec3d;

        public Sorter(Entity entityIn) {
            this.vec3d = entityIn.position();
        }

        public Sorter(Vec3 vec3d) {
            this.vec3d = vec3d;
        }

        @Override
        public int compare(Entity entity1, Entity entity2) {
            double d0 = this.vec3d.distanceToSqr(entity1.position());
            double d1 = this.vec3d.distanceToSqr(entity2.position());
            return Double.compare(d0, d1);
        }
    }
}

