/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util;

import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.common.item.IDyeableArmorItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.DamageResistant;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.consume_effects.ApplyStatusEffectsConsumeEffect;
import net.minecraft.world.item.consume_effects.ConsumeEffect;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.items.IItemHandler;

public class ItemUtil {
    private static int MAX_OVERVIEW = 3;

    public static ContentOverview getContentOverview(IItemHandler inventory) {
        HashMap<Item, Integer> retMap = new HashMap<Item, Integer>(MAX_OVERVIEW);
        int isMore = 0;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            Item item = stack.getItem();
            Integer existing = retMap.get(item);
            if (existing != null) {
                retMap.put(item, existing + stack.getCount());
                continue;
            }
            if (retMap.size() >= MAX_OVERVIEW) {
                ++isMore;
                continue;
            }
            retMap.put(item, stack.getCount());
        }
        return new ContentOverview(retMap, isMore);
    }

    public static CompoundTag_1_21_5 getTag(ItemStack stack) {
        CustomData custom_data = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        if (custom_data == CustomData.EMPTY) {
            return CompoundTag_1_21_5.createEmpty();
        }
        return CompoundTag_1_21_5.wrap(custom_data.copyTag());
    }

    public static void clearTag(ItemStack stack) {
        stack.set(DataComponents.CUSTOM_DATA, null);
    }

    public static void putTag(ItemStack stack, CompoundTag_1_21_5 tag) {
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag.wrapped()));
    }

    public static void modifyTag(ItemStack stack, Consumer<CompoundTag_1_21_5> tag_modifier) {
        CustomData custom_data = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CompoundTag_1_21_5 current_tag = CompoundTag_1_21_5.createEmpty();
        if (custom_data != CustomData.EMPTY) {
            current_tag = CompoundTag_1_21_5.wrap(custom_data.copyTag());
        }
        tag_modifier.accept(current_tag);
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)current_tag.wrapped()));
    }

    public static CompoundTag_1_21_5 getTagElement(ItemStack stack, String id) {
        CompoundTag_1_21_5 tag = ItemUtil.getTag(stack);
        if (!tag.contains(id, 10)) {
            return null;
        }
        return tag.getCompound(id);
    }

    public static boolean hasTag(ItemStack stack) {
        CustomData custom = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        return custom != null && !custom.isEmpty();
    }

    public static void copyTag(ItemStack from, ItemStack to) {
        CompoundTag fromTag = ((CustomData)from.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        to.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)fromTag));
    }

    public static boolean fireResistant(ItemStack stack) {
        return stack.has(DataComponents.DAMAGE_RESISTANT) && DamageTypeTags.IS_FIRE.equals((Object)((DamageResistant)stack.get(DataComponents.DAMAGE_RESISTANT)).types());
    }

    public static boolean isEddible(ItemStack stack) {
        return stack.has(DataComponents.FOOD);
    }

    public static boolean hasCustomHoverName(ItemStack stack) {
        return stack.has(DataComponents.CUSTOM_NAME);
    }

    public static Component getCustomHoverName(ItemStack stack) {
        return (Component)stack.get(DataComponents.CUSTOM_NAME);
    }

    public static void clearCustomHoverName(ItemStack stack) {
        stack.set(DataComponents.CUSTOM_NAME, null);
    }

    public static int getDyeColorForStack(ItemStack stack) {
        int default_color = 0xFFFFFF;
        int color_mask = -16777216;
        Item item = stack.getItem();
        if (item instanceof IDyeableArmorItem) {
            IDyeableArmorItem dye = (IDyeableArmorItem)item;
            default_color = dye.getDefaultColor(stack);
        }
        if (!stack.has(DataComponents.DYED_COLOR)) {
            return default_color;
        }
        return ((DyedItemColor)stack.getOrDefault(DataComponents.DYED_COLOR, (Object)new DyedItemColor(default_color))).rgb() | color_mask;
    }

    public static void setDyeColorForStack(ItemStack stack, int color) {
        stack.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(color));
    }

    public static Optional<ArmorTrim> getTrim(ItemStack stack) {
        if (!stack.has(DataComponents.TRIM) || !ItemUtil.isValidTrim_1_21_3(stack)) {
            return Optional.empty();
        }
        return Optional.ofNullable((ArmorTrim)stack.get(DataComponents.TRIM));
    }

    public static FoodProperties food(ItemStack stack) {
        return (FoodProperties)stack.get(DataComponents.FOOD);
    }

    public static CustomData getWrappedTag(ItemStack stack) {
        CustomData custom_data = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        return custom_data;
    }

    public static int getEnchantmentLevelForItem(ResourceKey<Enchantment> key, RegistryAccess prov, ItemStack stack) {
        Registry reg = prov.lookupOrThrow(Registries.ENCHANTMENT);
        Optional holder = reg.get(key);
        if (!holder.isPresent()) {
            return 0;
        }
        return stack.getEnchantmentLevel((Holder)holder.get());
    }

    public static Optional<Ingredient> getBlockIngredient(Block block) {
        return Optional.ofNullable(block.asItem()).filter(item -> item != Items.AIR).map(Ingredient::of);
    }

    public static EquipmentSlot getEquipmentSlot(ItemStack stack) {
        Equippable data = ItemUtil.getEquippable_1_21_3(stack);
        if (data == null) {
            return null;
        }
        return data.slot();
    }

    public static Equippable getEquippable_1_21_3(ItemStack stack) {
        return (Equippable)stack.get(DataComponents.EQUIPPABLE);
    }

    public static boolean isValidTrim_1_21_3(ItemStack stack) {
        Equippable equip = ItemUtil.getEquippable_1_21_3(stack);
        if (equip == null) {
            return false;
        }
        return equip.assetId().isPresent();
    }

    public static ResourceKey<EquipmentAsset> getEquippableModelUnsafe_1_21_3(ItemStack stack) {
        return (ResourceKey)ItemUtil.getEquippable_1_21_3(stack).assetId().get();
    }

    public static FoodProperties food_1_21_3(ItemStack stack) {
        return (FoodProperties)stack.get(DataComponents.FOOD);
    }

    public static Consumable consumable_1_21_3(ItemStack stack) {
        return (Consumable)stack.get(DataComponents.CONSUMABLE);
    }

    public static List<MobEffectInstance> foodEffect_1_21_3(ItemStack stack) {
        Consumable consumable = ItemUtil.consumable_1_21_3(stack);
        if (consumable == null) {
            return List.of();
        }
        List effects = consumable.onConsumeEffects();
        if (effects == null) {
            return List.of();
        }
        ArrayList<MobEffectInstance> mob_add_effects_list = new ArrayList<MobEffectInstance>();
        for (ConsumeEffect x : effects) {
            if (!(x instanceof ApplyStatusEffectsConsumeEffect)) continue;
            ApplyStatusEffectsConsumeEffect apply_status = (ApplyStatusEffectsConsumeEffect)x;
            mob_add_effects_list.addAll(apply_status.effects());
        }
        return mob_add_effects_list;
    }

    public static class ContentOverview {
        private final Map<Item, Integer> contents;
        private int isMore = 0;

        private ContentOverview(Map<Item, Integer> contents, int isMore) {
            this.contents = contents;
            this.isMore = isMore;
        }

        public int isMore() {
            return this.isMore;
        }

        public Map<Item, Integer> contents() {
            return this.contents;
        }
    }
}

