/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.client;

import com.chaosthedude.explorerscompass.ExplorersCompass;
import com.chaosthedude.explorerscompass.config.ConfigHandler;
import com.chaosthedude.explorerscompass.items.ExplorersCompassItem;
import com.chaosthedude.explorerscompass.util.CompassState;
import com.chaosthedude.explorerscompass.util.ItemUtils;
import com.chaosthedude.explorerscompass.util.RenderUtils;
import com.chaosthedude.explorerscompass.util.StructureUtils;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.gui.GuiLayer;

public class ExplorersCompassOverlay
implements GuiLayer {
    public static final Minecraft mc = Minecraft.getInstance();

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        LocalPlayer player;
        ItemStack stack;
        if (ExplorersCompassOverlay.mc.player != null && ExplorersCompassOverlay.mc.level != null && !ExplorersCompassOverlay.mc.options.hideGui && !mc.getDebugOverlay().showDebugScreen() && (ExplorersCompassOverlay.mc.screen == null || ((Boolean)ConfigHandler.CLIENT.displayWithChatOpen.get()).booleanValue() && ExplorersCompassOverlay.mc.screen instanceof ChatScreen) && (stack = ItemUtils.getHeldItem((Player)(player = ExplorersCompassOverlay.mc.player), ExplorersCompass.explorersCompass)) != null && stack.getItem() instanceof ExplorersCompassItem) {
            ExplorersCompassItem compass = (ExplorersCompassItem)stack.getItem();
            if (compass.getState(stack) == CompassState.SEARCHING) {
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, I18n.get((String)"string.explorerscompass.status", (Object[])new Object[0]), 5, 5, -1, 0);
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, I18n.get((String)"string.explorerscompass.searching", (Object[])new Object[0]), 5, 5, -5592406, 1);
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, I18n.get((String)"string.explorerscompass.structure", (Object[])new Object[0]), 5, 5, -1, 3);
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, StructureUtils.getPrettyStructureName(compass.getStructureKey(stack)), 5, 5, -5592406, 4);
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, I18n.get((String)"string.explorerscompass.radius", (Object[])new Object[0]), 5, 5, -1, 6);
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, String.valueOf(compass.getSearchRadius(stack)), 5, 5, -5592406, 7);
            } else if (compass.getState(stack) == CompassState.FOUND) {
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, I18n.get((String)"string.explorerscompass.status", (Object[])new Object[0]), 5, 5, -1, 0);
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, I18n.get((String)"string.explorerscompass.found", (Object[])new Object[0]), 5, 5, -5592406, 1);
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, I18n.get((String)"string.explorerscompass.structure", (Object[])new Object[0]), 5, 5, -1, 3);
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, StructureUtils.getPrettyStructureName(compass.getStructureKey(stack)), 5, 5, -5592406, 4);
                if (compass.shouldDisplayCoordinates(stack)) {
                    RenderUtils.drawConfiguredStringOnHUD(guiGraphics, I18n.get((String)"string.explorerscompass.coordinates", (Object[])new Object[0]), 5, 5, -1, 6);
                    RenderUtils.drawConfiguredStringOnHUD(guiGraphics, compass.getFoundStructureX(stack) + ", " + compass.getFoundStructureZ(stack), 5, 5, -5592406, 7);
                    RenderUtils.drawConfiguredStringOnHUD(guiGraphics, I18n.get((String)"string.explorerscompass.distance", (Object[])new Object[0]), 5, 5, -1, 9);
                    RenderUtils.drawConfiguredStringOnHUD(guiGraphics, String.valueOf(StructureUtils.getHorizontalDistanceToLocation((Player)player, compass.getFoundStructureX(stack), compass.getFoundStructureZ(stack))), 5, 5, -5592406, 10);
                }
            } else if (compass.getState(stack) == CompassState.NOT_FOUND) {
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, I18n.get((String)"string.explorerscompass.status", (Object[])new Object[0]), 5, 5, -1, 0);
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, I18n.get((String)"string.explorerscompass.notFound", (Object[])new Object[0]), 5, 5, -5592406, 1);
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, I18n.get((String)"string.explorerscompass.structure", (Object[])new Object[0]), 5, 5, -1, 3);
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, StructureUtils.getPrettyStructureName(compass.getStructureKey(stack)), 5, 5, -5592406, 4);
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, I18n.get((String)"string.explorerscompass.radius", (Object[])new Object[0]), 5, 5, -1, 6);
                RenderUtils.drawConfiguredStringOnHUD(guiGraphics, String.valueOf(compass.getSearchRadius(stack)), 5, 5, -5592406, 7);
            }
        }
    }
}

