/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch;

import com.mojang.blaze3d.platform.InputConstants;
import io.github.kosmx.emotes.PlatformTools;
import io.github.kosmx.emotes.arch.screen.ingame.FastMenuScreen;
import io.github.kosmx.emotes.common.CommonData;
import io.github.kosmx.emotes.main.EmoteHolder;
import io.github.kosmx.emotes.main.network.ClientEmotePlay;
import io.github.kosmx.emotes.main.network.ClientPacketManager;
import io.github.kosmx.emotes.server.serializer.UniversalEmoteSerializer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;

public class EmotecraftClientMod {
    public static final KeyMapping OPEN_MENU_KEY = new KeyMapping("key.emotecraft.fastchoose", InputConstants.Type.KEYSYM, 66, "category.emotecraft.keybinding");
    public static final KeyMapping STOP_EMOTE_KEY = new KeyMapping("key.emotecraft.stop", InputConstants.Type.KEYSYM, -1, "category.emotecraft.keybinding");
    private static int tick = 0;

    protected void onInitializeClient() {
        EmotecraftClientMod.loadEmotes();
        ClientPacketManager.init();
    }

    protected void onClientTick(Minecraft minecraft) {
        if (tick++ % 21 == 20) {
            ClientEmotePlay.checkQueue();
        }
        if (OPEN_MENU_KEY.consumeClick() && (PlatformTools.getConfig().alwaysOpenEmoteScreen.get().booleanValue() || minecraft.player == minecraft.getCameraEntity())) {
            minecraft.setScreen((Screen)new FastMenuScreen(null));
        }
        if (STOP_EMOTE_KEY.consumeClick()) {
            ClientEmotePlay.clientStopLocalEmote();
        }
    }

    public static CompletableFuture<Void> loadEmotes() {
        return ((CompletableFuture)CompletableFuture.supplyAsync(UniversalEmoteSerializer::loadEmotes, (Executor)Util.ioPool()).thenAccept(emotes -> {
            EmoteHolder.clearEmotes();
            EmoteHolder.addEmoteToList(UniversalEmoteSerializer.getLoadedEmotes(), null);
        })).exceptionally(th -> {
            CommonData.LOGGER.error("Failed to reload emotes!", th);
            return null;
        });
    }

    public static int getTick() {
        return tick;
    }
}

