/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.gui.widgets;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.platform.InputConstants;
import io.github.kosmx.emotes.PlatformTools;
import io.github.kosmx.emotes.arch.gui.widgets.search.ISearchEngine;
import io.github.kosmx.emotes.arch.gui.widgets.search.VanillaSearch;
import io.github.kosmx.emotes.arch.screen.utils.BageUtils;
import io.github.kosmx.emotes.main.EmoteHolder;
import io.github.kosmx.emotes.mc.McUtils;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmoteListWidget
extends ObjectSelectionList<ListEntry> {
    private static final List<Component> LAST_OPENED_PATH = new CopyOnWriteArrayList<Component>();
    private final FolderEntry mainFolder;
    private FolderEntry lastClickedFolder;
    private boolean compactMode;
    private final Button backButton;

    public EmoteListWidget(Minecraft minecraft, int width, int height, int y, int itemHeight) {
        Objects.requireNonNull(minecraft.font);
        super(minecraft, width, height, y, itemHeight, 9);
        this.mainFolder = new FolderEntry((Component)Component.translatable((String)"emotecraft.folder.main"));
        this.backButton = Button.builder((Component)McUtils.BACK, button -> {
            this.setLastFolder(null);
            if (this.lastClickedFolder == null) {
                this.setScrollAmount(0.0);
            } else {
                this.centerScrollOn((AbstractSelectionList.Entry)this.lastClickedFolder);
            }
        }).width(20).build();
        this.centerListVertically = false;
        this.backButton.active = false;
    }

    public int getRowWidth() {
        if (this.compactMode) {
            return this.width;
        }
        return this.width / 2;
    }

    protected int scrollBarX() {
        if (!this.compactMode) {
            return super.scrollBarX();
        }
        return this.getX() + this.getRowWidth() - 6;
    }

    protected void renderHeader(GuiGraphics guiGraphics, int x, int y) {
        MutableComponent path = EmoteListWidget.appendScreenPath(this.mainFolder, Component.empty());
        if (this.compactMode) {
            EmoteListWidget.renderScrollingString((GuiGraphics)guiGraphics, (Font)this.minecraft.font, (Component)path, (int)x, (int)x, (int)(y - 4), (int)(this.getRowRight() - 3), (int)(y + this.headerHeight - 4), (int)-1);
        } else {
            EmoteListWidget.renderScrollingString((GuiGraphics)guiGraphics, (Font)this.minecraft.font, (Component)path, (int)(this.getX() + 3), (int)(y - 4), (int)(this.getRight() - 3), (int)(y + this.headerHeight - 4), (int)-1);
        }
    }

    protected void renderSelection(@NotNull GuiGraphics guiGraphics, int top, int width, int height, int outerColor, int innerColor) {
        if (this.compactMode && this.scrollbarVisible()) {
            int o = this.getRowLeft() - 2;
            int p = this.getRight() - 6 - 1;
            int q = top - 2;
            int r = top + height + 2;
            guiGraphics.fill(o, q, p, r, outerColor);
            guiGraphics.fill(o + 1, q + 1, p - 1, r - 1, innerColor);
        } else {
            super.renderSelection(guiGraphics, top, width, height, outerColor, innerColor);
        }
    }

    protected void renderItem(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, int index, int left, int top, int width, int height) {
        try {
            super.renderItem(guiGraphics, mouseX, mouseY, partialTick, index, left, top, width, height);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setEmotes(Iterable<EmoteHolder> list, boolean showInvalid) {
        Component folderName;
        ListEntry child;
        this.mainFolder.entries.clear();
        for (EmoteHolder emoteHolder : list) {
            if (emoteHolder.folder.isEmpty()) {
                this.mainFolder.entries.put(emoteHolder.name, new EmoteEntry(emoteHolder));
                continue;
            }
            this.createFoldersTree(emoteHolder.folder).entries.put(emoteHolder.name, new EmoteEntry(emoteHolder));
        }
        if (showInvalid) {
            for (EmoteHolder emoteHolder : this.getEmptyEmotes()) {
                this.mainFolder.entries.put(emoteHolder.name, new EmoteEntry(emoteHolder));
            }
        }
        this.filter(VanillaSearch.INSTANCE, false, "");
        Iterator<EmoteHolder> iterator = LAST_OPENED_PATH.iterator();
        while (iterator.hasNext() && (child = Objects.requireNonNullElse(this.lastClickedFolder, this.mainFolder).entries.get(folderName = (Component)iterator.next())) instanceof FolderEntry) {
            FolderEntry folder;
            this.lastClickedFolder = folder = (FolderEntry)child;
            this.setLastFolder(folder);
        }
    }

    public void filter(ISearchEngine engine, boolean isSearchActive, String search) {
        this.clearEntries();
        engine.filter(this.getEmotes(isSearchActive).stream(), search).forEach(x$0 -> this.addEntry((AbstractSelectionList.Entry)x$0));
        this.refreshScrollAmount();
    }

    public FolderEntry createFoldersTree(List<Component> folders) {
        FolderEntry last = this.mainFolder;
        for (Component folder : folders) {
            last = last.getOrCreateFolder(folder);
        }
        return last;
    }

    public Iterable<EmoteHolder> getEmptyEmotes() {
        LinkedList<EmoteHolder> empties = new LinkedList<EmoteHolder>();
        for (Pair<UUID, InputConstants.Key> pair : PlatformTools.getConfig().emoteKeyMap) {
            if (EmoteHolder.list.containsKey(pair.left())) continue;
            empties.add(new EmoteHolder.Empty((UUID)pair.left()));
        }
        return empties;
    }

    public List<ListEntry> getEmotes(boolean isSearchActive) {
        ArrayList<ListEntry> emotes = new ArrayList<ListEntry>();
        this.mainFolder.collectEmotes(isSearchActive, emotes);
        emotes.sort(ListEntry::compareTo);
        return Collections.unmodifiableList(emotes);
    }

    public void updateSize(int width, HeaderAndFooterLayout layout) {
        super.updateSize(width, layout);
        if (this.compactMode) {
            layout.arrangeElements();
        }
    }

    public void updateSizeAndPosition(int width, int height, int y) {
        super.updateSizeAndPosition(this.compactMode ? width / 3 : width, height, y);
    }

    @Nullable
    public EmoteHolder getFocusedEmote() {
        AbstractSelectionList.Entry entry = this.getFocused();
        if (entry instanceof EmoteEntry) {
            EmoteEntry emote = (EmoteEntry)entry;
            return emote.getEmote();
        }
        return null;
    }

    @Nullable
    public ListEntry getHovered() {
        return (ListEntry)super.getHovered();
    }

    public void setSelected(@Nullable ListEntry selected) {
        super.setSelected((AbstractSelectionList.Entry)selected);
        if (selected instanceof FolderEntry) {
            FolderEntry folder;
            this.lastClickedFolder = folder = (FolderEntry)selected;
            this.setLastFolder(folder);
        }
    }

    public boolean setLastFolder(FolderEntry folder) {
        if (this.mainFolder.setLastFolder(folder)) {
            this.backButton.active = this.mainFolder.next != null;
            LAST_OPENED_PATH.clear();
            EmoteListWidget.updateLastOpenedPath(this.mainFolder.next);
            return true;
        }
        return false;
    }

    public void setCompactMode(boolean compactMode) {
        this.compactMode = compactMode;
    }

    public static MutableComponent appendScreenPath(FolderEntry folder, MutableComponent component) {
        component = component.append(McUtils.SLASH).append(CommonComponents.SPACE);
        if (folder.next != null) {
            return EmoteListWidget.appendScreenPath(folder.next, component.append(folder.name).append(CommonComponents.SPACE));
        }
        return component.append((Component)folder.name.copy().withStyle(style -> style.withBold(Boolean.valueOf(true))));
    }

    private static void updateLastOpenedPath(@Nullable FolderEntry folder) {
        if (folder == null) {
            return;
        }
        LAST_OPENED_PATH.add(folder.name);
        if (folder.next != null) {
            EmoteListWidget.updateLastOpenedPath(folder.next);
        }
    }

    public Button createBackButton() {
        return this.backButton;
    }

    public class FolderEntry
    extends ListEntry {
        public static final ResourceLocation FOLDER = McUtils.newIdentifier("textures/folder.png");
        public static final ResourceLocation FOLDER_OPEN = McUtils.newIdentifier("textures/folder_open.png");
        public static final Component FOLDER_DESC = Component.translatable((String)"emotecraft.folder");
        private final Map<Component, ListEntry> entries;
        private FolderEntry next;

        public FolderEntry(Component name) {
            super(name, FOLDER_DESC, Collections.emptyList());
            this.entries = new HashMap<Component, ListEntry>();
        }

        @Override
        public void renderAdditional(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, hovering ? FOLDER_OPEN : FOLDER, left, top, 0.0f, 0.0f, 32, 32, 32, 32);
        }

        @Override
        protected void collectEmotes(boolean isSearchActive, List<ListEntry> collection) {
            if (this.next == null || !this.entries.containsValue(this.next)) {
                for (ListEntry entry : this.entries.values()) {
                    if (entry instanceof FolderEntry) {
                        FolderEntry folder = (FolderEntry)entry;
                        boolean isInvalid = StringUtils.isBlank((CharSequence)this.name.getString());
                        if (!isInvalid) {
                            collection.add(folder);
                        }
                        if (!isSearchActive && !isInvalid) continue;
                        for (ListEntry folderEntry : folder.entries.values()) {
                            folderEntry.collectEmotes(isSearchActive, collection);
                        }
                        continue;
                    }
                    entry.collectEmotes(isSearchActive, collection);
                }
            } else {
                this.next.collectEmotes(isSearchActive, collection);
            }
        }

        public boolean setLastFolder(FolderEntry folder) {
            if (this.next != null) {
                if (folder == null && this.next.next == null) {
                    this.setSelectedFolder(null);
                    return true;
                }
                return this.next.setLastFolder(folder);
            }
            return this.setSelectedFolder(folder);
        }

        public boolean setSelectedFolder(FolderEntry folder) {
            if (folder == null || this.entries.containsValue(folder)) {
                this.next = folder;
                return true;
            }
            return false;
        }

        public FolderEntry getOrCreateFolder(Component name) {
            return (FolderEntry)this.entries.computeIfAbsent(name, x$0 -> new FolderEntry((Component)x$0));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof FolderEntry)) return false;
            FolderEntry entry = (FolderEntry)obj;
            if (!this.name.equals((Object)entry.name)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public int compareTo(@NotNull ListEntry o) {
            if (o instanceof FolderEntry) {
                return super.compareTo(o);
            }
            return -1;
        }
    }

    public class EmoteEntry
    extends ListEntry {
        public final EmoteHolder emote;

        public EmoteEntry(EmoteHolder emote) {
            super(emote.name, emote.description, emote.bages);
            this.emote = emote;
        }

        @Override
        public void renderAdditional(GuiGraphics matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            ResourceLocation texture;
            if (!this.emote.author.getString().isEmpty()) {
                MutableComponent text = Component.translatable((String)"emotecraft.emote.author").withStyle(ChatFormatting.GOLD).append(this.emote.author);
                matrices.drawString(((EmoteListWidget)EmoteListWidget.this).minecraft.font, (Component)text, x + 34, y + 23, -8355712);
            }
            if ((texture = this.emote.getIconIdentifier()) != null) {
                GlStateManager._enableBlend();
                matrices.blit(RenderPipelines.GUI_TEXTURED, texture, x, y, 0.0f, 0.0f, 32, 32, 256, 256, 256, 256);
                GlStateManager._disableBlend();
            }
        }

        public EmoteHolder getEmote() {
            return this.emote;
        }

        @Override
        @NotNull
        public Component getNarration() {
            return this.emote.name;
        }

        @Override
        public boolean matches(String string) {
            return super.matches(string) || this.description.getString().toLowerCase().contains(string.toLowerCase()) || this.emote.fileName != null && this.emote.fileName.getString().toLowerCase().contains(string.toLowerCase()) || this.emote.author.getString().equalsIgnoreCase(string);
        }

        @Override
        protected void collectEmotes(boolean excludeFolders, List<ListEntry> collection) {
            collection.add(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof EmoteEntry)) return false;
            EmoteEntry entry = (EmoteEntry)obj;
            if (!this.emote.equals(entry.emote)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return this.emote.hashCode();
        }

        @Override
        public int compareTo(@NotNull ListEntry o) {
            if (o instanceof EmoteEntry) {
                return super.compareTo(o);
            }
            return 1;
        }
    }

    public abstract class ListEntry
    extends ObjectSelectionList.Entry<ListEntry>
    implements Comparable<ListEntry> {
        public final Component name;
        public final Component description;
        public final List<Component> bages;

        public ListEntry(Component name, Component description, List<Component> bages) {
            this.name = name;
            this.description = description;
            this.bages = bages;
        }

        public void render(GuiGraphics matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            int maxX = x + entryWidth - 3 - (EmoteListWidget.this.compactMode && EmoteListWidget.this.scrollbarVisible() ? 7 : 0);
            matrices.enableScissor(x - 1, y - 1, maxX, y + entryHeight + 1);
            if (hovered) {
                matrices.fill(x - 1, y - 1, maxX, y + entryHeight + 1, ARGB.color((int)128, (int)66, (int)66, (int)66));
            }
            int maxBadgesWidth = Math.max(maxX - ((EmoteListWidget)EmoteListWidget.this).minecraft.font.width((FormattedText)this.name), maxX / 3) - (x + 34);
            int badgeWidth = BageUtils.drawBadges(matrices, ((EmoteListWidget)EmoteListWidget.this).minecraft.font, this.bages, maxX, y + 1, maxBadgesWidth, true);
            Font font = ((EmoteListWidget)EmoteListWidget.this).minecraft.font;
            Objects.requireNonNull(((EmoteListWidget)EmoteListWidget.this).minecraft.font);
            EmoteListWidget.renderScrollingString((GuiGraphics)matrices, (Font)font, (Component)this.name, (int)(x + 34), (int)(x + 34), (int)(y + 1), (int)(maxX - badgeWidth), (int)(y + 1 + 9), (int)-1);
            matrices.drawString(((EmoteListWidget)EmoteListWidget.this).minecraft.font, this.description, x + 34, y + 12, -8355712);
            this.renderAdditional(matrices, index, y, x, entryWidth, entryHeight, mouseX, mouseY, hovered, tickDelta);
            matrices.disableScissor();
        }

        public abstract void renderAdditional(GuiGraphics var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9, float var10);

        @NotNull
        public Component getNarration() {
            return this.name;
        }

        public boolean matches(String string) {
            return this.name.getString().toLowerCase().contains(string.toLowerCase());
        }

        protected abstract void collectEmotes(boolean var1, List<ListEntry> var2);

        public abstract boolean equals(Object var1);

        public abstract int hashCode();

        @Override
        public int compareTo(@NotNull ListEntry o) {
            return this.name.getString().compareTo(o.name.getString());
        }
    }
}

