/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.mixin;

import io.github.kosmx.emotes.main.mixinFunctions.IPlayerEntity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity {
    @Shadow
    public abstract boolean isLocalPlayer();

    protected PlayerMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"updatePlayerPose()V"}, at={@At(value="TAIL")})
    private void updatePlayerPoseEvent(CallbackInfo ci) {
        PlayerMixin playerMixin;
        if (this.isLocalPlayer() && (playerMixin = this) instanceof IPlayerEntity) {
            IPlayerEntity animator = (IPlayerEntity)((Object)playerMixin);
            if (this.getPose() == Pose.CROUCHING || this.getPose() == Pose.DYING || this.getPose() == Pose.SWIMMING || this.getPose() == Pose.FALL_FLYING || this.getPose() == Pose.SLEEPING) {
                animator.emotecraft$playerEntersInvalidPose();
            }
        }
    }
}

