/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.network.client;

import dev.architectury.injectables.annotations.ExpectPlatform;
import io.github.kosmx.emotes.PlatformTools;
import io.github.kosmx.emotes.api.proxy.AbstractNetworkInstance;
import io.github.kosmx.emotes.api.proxy.INetworkInstance;
import io.github.kosmx.emotes.arch.network.EmotePacketPayload;
import io.github.kosmx.emotes.arch.network.NetworkPlatformTools;
import io.github.kosmx.emotes.arch.network.client.neoforge.ClientNetworkImpl;
import io.github.kosmx.emotes.common.CommonData;
import io.github.kosmx.emotes.common.network.EmotePacket;
import io.github.kosmx.emotes.common.network.PacketTask;
import io.github.kosmx.emotes.common.network.objects.NetData;
import io.github.kosmx.emotes.main.EmoteHolder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClientNetwork
extends AbstractNetworkInstance {
    public static ClientNetwork INSTANCE = new ClientNetwork();
    private boolean isConfiguredNormally;

    @Override
    public boolean isActive() {
        return ClientNetwork.isServerChannelOpen(NetworkPlatformTools.EMOTE_CHANNEL_ID.id());
    }

    @Override
    public void sendMessage(EmotePacket.Builder builder, @Nullable UUID target) throws IOException {
        if (target != null) {
            builder.configureTarget(target);
        }
        EmotePacket writer = builder.build();
        this.sendMessage(writer.write(), null);
        if (writer.data.emoteData != null && writer.data.emoteData.data().has("song") && !writer.data.writeSong) {
            PlatformTools.addToast((Component)Component.translatable((String)"emotecraft.song_too_big_to_send"));
        }
    }

    @Override
    protected void sendMessage(byte[] bytes, @Nullable UUID target) {
        this.sendMessage(ByteBuffer.wrap(bytes), null);
    }

    @Override
    public void sendMessage(ByteBuffer byteBuffer, @Nullable UUID target) {
        ClientNetwork.sendPlayPacket(EmotePacketPayload.playPacket(byteBuffer));
        if (byteBuffer.remaining() >= this.maxDataSize()) {
            CommonData.LOGGER.error("Sent packet size is {} byte(s)!", (Object)byteBuffer.remaining());
        }
    }

    @ExpectPlatform
    @Contract
    @ExpectPlatform.Transformed
    public static boolean isServerChannelOpen(ResourceLocation id) {
        return ClientNetworkImpl.isServerChannelOpen(id);
    }

    @ExpectPlatform
    @Contract
    @ExpectPlatform.Transformed
    public static void sendPlayPacket(CustomPacketPayload packet) {
        ClientNetworkImpl.sendPlayPacket(packet);
    }

    public void receiveStreamMessage(@NotNull ByteBuffer buff, @Nullable Consumer<CustomPacketPayload> configPacketConsumer) throws IOException {
        CommonData.LOGGER.error("Streaming message received!");
    }

    public void receiveConfigMessage(@NotNull ByteBuffer buf, @NotNull Consumer<CustomPacketPayload> consumer) throws IOException {
        NetData packet = new EmotePacket.Builder().build().read(buf);
        if (packet.purpose == PacketTask.CONFIG) {
            this.setVersions(packet.versions);
            this.sendC2SConfig(p -> {
                try {
                    consumer.accept(EmotePacketPayload.playPacket(p.build().write()));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            this.isConfiguredNormally = true;
        } else if (packet.purpose == PacketTask.FILE) {
            EmoteHolder.addEmoteToList(packet.emoteData, (INetworkInstance)this);
        } else {
            CommonData.LOGGER.warn("Invalid emotes packet type in configuration phase: " + String.valueOf((Object)packet.purpose));
        }
    }

    @Deprecated
    public void configureOnPlay(@NotNull Consumer<CustomPacketPayload> consumer) {
        if (!this.isConfiguredNormally && this.isActive()) {
            CommonData.LOGGER.warn("The server failed to configure the client, attempting to configure...");
            this.sendC2SConfig(p -> {
                try {
                    consumer.accept(EmotePacketPayload.playPacket(p.build().write()));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    @Override
    public void disconnect() {
        super.disconnect();
        this.isConfiguredNormally = false;
    }

    @Override
    public int maxDataSize() {
        return super.maxDataSize() - 16;
    }
}

