/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.screen.components;

import com.zigythebird.playeranimcore.animation.Animation;
import io.github.kosmx.emotes.PlatformTools;
import io.github.kosmx.emotes.arch.gui.widgets.EmoteListWidget;
import io.github.kosmx.emotes.arch.gui.widgets.PlayerPreview;
import io.github.kosmx.emotes.arch.gui.widgets.search.ISearchEngine;
import io.github.kosmx.emotes.arch.screen.utils.EmoteListener;
import io.github.kosmx.emotes.common.CommonData;
import io.github.kosmx.emotes.server.serializer.EmoteSerializer;
import io.github.kosmx.emotes.server.serializer.EmoteWriter;
import io.github.kosmx.emotes.server.services.InstanceService;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public abstract class EmoteSubScreen
extends Screen {
    private static final Component SEARCH = Component.translatable((String)"gui.recipebook.search_hint");
    protected final boolean reloadOnOpen;
    protected final ISearchEngine searchEngine;
    protected Screen lastScreen;
    @Nullable
    public EmoteListener watcher;
    @Nullable
    protected PlayerPreview preview;
    @Nullable
    protected EmoteListWidget list;
    protected HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this);
    @Nullable
    protected EditBox searchBox;

    protected EmoteSubScreen(Component title, boolean reloadOnOpen, Screen lastScreen) {
        this(title, reloadOnOpen, ISearchEngine.getInstance(), lastScreen);
    }

    protected EmoteSubScreen(Component title, boolean reloadOnOpen, ISearchEngine searchEngine, Screen lastScreen) {
        super(title);
        this.reloadOnOpen = reloadOnOpen;
        this.searchEngine = searchEngine;
        this.lastScreen = lastScreen;
    }

    public void added() {
        if (this.watcher == null) {
            this.watcher = EmoteListener.create(InstanceService.INSTANCE.getExternalEmoteDir());
            if (this.reloadOnOpen && this.watcher != null) {
                this.watcher.load(this::addOptions, (Executor)this.minecraft);
            }
        }
        super.added();
    }

    protected void init() {
        this.addTitle();
        this.addPlayerPreview();
        this.addContents();
        this.addFooter();
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    protected void addTitle() {
        this.searchBox = (EditBox)this.layout.addToHeader((LayoutElement)this.searchEngine.createEditBox(this.font, SEARCH, () -> Objects.requireNonNull(this.list).getEmotes(this.isSearchActive())));
        this.searchBox.setHint(SEARCH);
        this.searchBox.setResponder(string -> Objects.requireNonNull(this.list).filter(this.searchEngine, this.isSearchActive(), (String)string));
    }

    protected void addPlayerPreview() {
        this.preview = (PlayerPreview)this.layout.addToContents((LayoutElement)new PlayerPreview(this.minecraft.getGameProfile(), 0, 0, 0, 0, true), layoutSettings -> layoutSettings.alignHorizontallyLeft().paddingLeft(8));
    }

    protected EmoteListWidget newEmoteListWidget() {
        return new EmoteListWidget(this.minecraft, this.width, this.layout.getContentHeight(), this.layout.getHeaderHeight(), 36){

            @Override
            public void setSelected(@Nullable EmoteListWidget.ListEntry entry) {
                super.setSelected(entry);
                EmoteSubScreen.this.onPressed(entry);
            }

            @Override
            public boolean setLastFolder(EmoteListWidget.FolderEntry folder) {
                if (super.setLastFolder(folder)) {
                    if (EmoteSubScreen.this.searchBox != null) {
                        EmoteSubScreen.this.searchBox.setValue("");
                    }
                    if (EmoteSubScreen.this.preview != null) {
                        EmoteSubScreen.this.preview.getPlayer().stopEmote();
                    }
                    return true;
                }
                return false;
            }
        };
    }

    protected void addContents() {
        this.list = (EmoteListWidget)this.layout.addToContents((LayoutElement)this.newEmoteListWidget());
        this.addOptions();
    }

    protected abstract void addOptions();

    protected void addFooter() {
        LinearLayout linearLayout = (LinearLayout)this.layout.addToFooter((LayoutElement)LinearLayout.horizontal().spacing(8));
        if (this.list != null) {
            linearLayout.addChild((LayoutElement)this.list.createBackButton());
        }
        linearLayout.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).width(200).build());
    }

    protected abstract void onPressed(@Nullable EmoteListWidget.ListEntry var1);

    protected void repositionElements() {
        this.layout.arrangeElements();
        if (this.preview != null) {
            this.preview.setSize(this.width / 6, this.height / 2);
        }
        if (this.list != null) {
            this.list.updateSize(this.width, this.layout);
            if (this.preview != null) {
                this.preview.visible = this.preview.getRight() <= this.list.getRowLeft();
            }
        }
    }

    public void tick() {
        if (this.watcher != null) {
            try {
                if (this.watcher.pollForChanges()) {
                    this.watcher.load(this::addOptions, (Executor)this.minecraft);
                }
            }
            catch (IOException ex) {
                CommonData.LOGGER.warn("Failed to poll for directory changes, stopping", (Throwable)ex);
                this.closeWatcher();
            }
        }
        super.tick();
        if (this.preview != null) {
            EmoteListWidget.ListEntry hovered = this.list.getHovered();
            if (this.list.getSelected() == hovered) {
                hovered = null;
            }
            if (hovered instanceof EmoteListWidget.EmoteEntry) {
                EmoteListWidget.EmoteEntry emote = (EmoteListWidget.EmoteEntry)hovered;
                this.preview.playAnimation(emote.emote.emote, true);
            } else if (hovered instanceof EmoteListWidget.FolderEntry) {
                this.preview.getPlayer().stopEmote();
            }
            this.preview.tick();
        }
    }

    public void removed() {
        if (this.watcher != null) {
            this.watcher.blockWhileLoading();
        }
        super.removed();
        if (this.preview != null) {
            this.preview.getPlayer().stopEmote();
        }
    }

    private void closeWatcher() {
        if (this.watcher != null) {
            try {
                this.watcher.close();
                this.watcher = null;
            }
            catch (Throwable th) {
                CommonData.LOGGER.warn("Failed to close watcher!", th);
            }
        }
    }

    public void onClose() {
        if (this.watcher != null && this.watcher.isLoading()) {
            PlatformTools.addToast(EmoteListener.RELOADING_WAIT);
            return;
        }
        this.minecraft.setScreen(this.lastScreen);
    }

    public boolean shouldCloseOnEsc() {
        return this.watcher == null || !this.watcher.isLoading();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.searchEngine.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.searchEngine.mouseScrolled(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public void onFilesDrop(List<Path> paths) {
        for (Path path : paths) {
            try {
                Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);
                try {
                    stream.forEach(emote -> {
                        List<Animation> animations = EmoteSerializer.serializeExternalEmote(emote);
                        if (animations.isEmpty()) {
                            return;
                        }
                        for (Animation animation : animations) {
                            try {
                                EmoteWriter.writeAnimationInBestFormat(animation, InstanceService.INSTANCE.getExternalEmoteDir());
                            }
                            catch (Throwable th) {
                                CommonData.LOGGER.warn("Failed to move animation!", th);
                            }
                        }
                    });
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Throwable th) {
                CommonData.LOGGER.warn("Failed to walk!", th);
            }
        }
    }

    public boolean isSearchActive() {
        return this.searchBox != null && !StringUtils.isBlank((CharSequence)this.searchBox.getValue());
    }
}

