/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.screen.ingame;

import io.github.kosmx.emotes.arch.EmotecraftClientMod;
import io.github.kosmx.emotes.arch.screen.ingame.FullMenuScreen;
import io.github.kosmx.emotes.arch.screen.widget.AbstractFastChooseWidget;
import io.github.kosmx.emotes.arch.screen.widget.FastChooseController;
import io.github.kosmx.emotes.arch.screen.widget.IChooseElement;
import io.github.kosmx.emotes.arch.screen.widget.preview.PreviewFastChooseWidget;
import io.github.kosmx.emotes.main.network.ClientPacketManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class FastMenuScreen
extends Screen
implements FastChooseController {
    protected static final Component TITLE = Component.translatable((String)"emotecraft.fastmenu");
    private static final Component WARN_NO_EMOTECRAFT = Component.translatable((String)"emotecraft.no_server");
    private static final Component WARN_ONLY_PROXY = Component.translatable((String)"emotecraft.only_proxy");
    private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this);
    protected final Screen parent;
    protected AbstractFastChooseWidget fastMenu;

    public FastMenuScreen(Screen parent) {
        super(TITLE);
        this.parent = parent;
    }

    public void init() {
        if (!ClientPacketManager.isRemoteAvailable()) {
            if (ClientPacketManager.isAvailableProxy()) {
                this.layout.addTitleHeader(WARN_ONLY_PROXY, this.font);
            } else {
                this.layout.addTitleHeader(WARN_NO_EMOTECRAFT, this.font);
            }
        }
        this.fastMenu = (AbstractFastChooseWidget)this.layout.addToContents((LayoutElement)new PreviewFastChooseWidget((FastChooseController)this, true, 0, 0, 0));
        LinearLayout linearLayout = (LinearLayout)this.layout.addToFooter((LayoutElement)LinearLayout.horizontal().spacing(8));
        linearLayout.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> this.onClose()).width(120).build());
        linearLayout.addChild((LayoutElement)Button.builder((Component)FullMenuScreen.TITLE, button -> this.minecraft.setScreen((Screen)new FullMenuScreen(this))).width(120).build());
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    protected void repositionElements() {
        if (this.fastMenu != null) {
            int size = (int)Math.min((double)this.width * 0.8, (double)this.height * 0.8);
            this.fastMenu.setSize(size, size);
        }
        this.layout.arrangeElements();
    }

    public void removed() {
        super.removed();
        if (this.fastMenu != null) {
            this.fastMenu.removed();
        }
    }

    protected void renderBlurredBackground(GuiGraphics guiGraphics) {
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (EmotecraftClientMod.OPEN_MENU_KEY.matches(keyCode, scanCode)) {
            this.onClose();
            return true;
        }
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (EmotecraftClientMod.OPEN_MENU_KEY.matchesMouse(button)) {
            this.onClose();
            return true;
        }
        return false;
    }

    public void tick() {
        super.tick();
        if (this.fastMenu != null) {
            this.fastMenu.tick();
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    @Override
    public boolean doHoverPart(IChooseElement part) {
        return part.hasEmote();
    }

    @Override
    public boolean isValidClickButton(int button) {
        return button == 0;
    }

    @Override
    public boolean onClick(IChooseElement element, int button) {
        if (element.getEmote() != null) {
            boolean bl = element.getEmote().playEmote();
            if (bl) {
                Minecraft.getInstance().setScreen(null);
            }
            return bl;
        }
        return false;
    }

    @Override
    public boolean doesShowInvalid() {
        return false;
    }
}

