/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.screen.widget.preview.elemets;

import io.github.kosmx.emotes.PlatformTools;
import io.github.kosmx.emotes.arch.screen.widget.AbstractFastChooseWidget;
import io.github.kosmx.emotes.arch.screen.widget.IChooseElement;
import io.github.kosmx.emotes.main.EmoteHolder;
import java.time.Duration;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public abstract class PlayerChooseElement
extends AbstractWidget
implements IChooseElement {
    protected final AbstractFastChooseWidget parent;
    protected final int id;

    public PlayerChooseElement(AbstractFastChooseWidget parent, int id) {
        super(0, 0, 0, 0, (Component)Component.empty());
        this.parent = parent;
        this.id = id;
    }

    protected abstract void updateRectangle();

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        EmoteHolder emoteHolder;
        Optional<ResourceLocation> icon;
        this.isHovered = this.isHovered && this.parent.controller.doHoverPart(this);
        this.updateRectangle();
        if (this.isHoveredOrFocused()) {
            this.renderHover(guiGraphics);
        }
        if ((icon = Optional.ofNullable(emoteHolder = this.getEmote()).map(EmoteHolder::getIconIdentifier)).isPresent()) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, icon.orElseThrow(), this.getX(), this.getY(), 0.0f, 0.0f, this.getWidth(), this.getHeight(), 256, 256, 256, 256);
        } else if (this.getEmote() != null) {
            PlayerChooseElement.renderScrollingString((GuiGraphics)guiGraphics, (Font)Minecraft.getInstance().font, (Component)this.getEmote().name, (int)this.getX(), (int)this.getY(), (int)(this.getX() + this.getWidth()), (int)(this.getY() + this.getHeight()), (int)-1);
        }
        if (this.isHoveredOrFocused() && emoteHolder != null) {
            this.setTooltip(Tooltip.create((Component)emoteHolder.name));
            this.setTooltipDelay(Duration.ZERO);
        } else {
            this.setTooltip(null);
        }
    }

    protected abstract void renderHover(GuiGraphics var1);

    @Override
    public void removed() {
    }

    @Override
    public boolean hasEmote() {
        return PlatformTools.getConfig().fastMenuEmotes[this.parent.getCurrentPage()][this.id] != null;
    }

    @Override
    public EmoteHolder getEmote() {
        UUID uuid = PlatformTools.getConfig().fastMenuEmotes[this.parent.getCurrentPage()][this.id];
        if (uuid != null) {
            EmoteHolder emote = (EmoteHolder)EmoteHolder.list.get(uuid);
            if (emote == null && this.parent.controller.doesShowInvalid()) {
                emote = new EmoteHolder.Empty(uuid);
            }
            return emote;
        }
        return null;
    }

    @Override
    public void clearEmote() {
        this.setEmote(null);
    }

    @Override
    public void setEmote(EmoteHolder emote) {
        PlatformTools.getConfig().fastMenuEmotes[this.parent.getCurrentPage()][this.id] = emote == null ? null : emote.getUuid();
    }

    protected boolean isValidClickButton(int button) {
        return this.parent.controller.isValidClickButton(button);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return this.parent.controller.onClick(this, button);
        }
        return false;
    }

    public void playDownSound(SoundManager handler) {
        PlayerChooseElement.playButtonClickSound((SoundManager)handler);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        this.defaultButtonNarrationText(narrationElementOutput);
    }
}

