/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.screen.widget.preview.elemets;

import com.mojang.authlib.GameProfile;
import com.zigythebird.playeranimcore.easing.EasingType;
import io.github.kosmx.emotes.arch.screen.widget.AbstractFastChooseWidget;
import io.github.kosmx.emotes.arch.screen.widget.preview.PreviewFastChooseWidget;
import io.github.kosmx.emotes.arch.screen.widget.preview.elemets.PlayerChooseElement;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;

public class PlayerChooseSquareElement
extends PlayerChooseElement {
    private static final Float2FloatFunction EASING_TRANSFORMER = EasingType.EASE_IN_CIRC.buildTransformer(null);
    protected final int dx;
    protected final int dy;
    private boolean isAnimFinishing;

    public PlayerChooseSquareElement(AbstractFastChooseWidget parent, GameProfile profile, int id, int dx, int dy) {
        super(parent, id);
        this.dx = dx;
        this.dy = dy;
    }

    @Override
    protected void updateRectangle() {
        float f;
        AbstractFastChooseWidget abstractFastChooseWidget = this.parent;
        if (abstractFastChooseWidget instanceof PreviewFastChooseWidget) {
            PreviewFastChooseWidget widget = (PreviewFastChooseWidget)abstractFastChooseWidget;
            f = widget.getAnimTime();
        } else {
            f = 0.0f;
        }
        float progress = f;
        float easedProgress = 1.0f - EASING_TRANSFORMER.get(progress);
        this.isAnimFinishing = easedProgress > 0.9f;
        int s = this.parent.globalPadding();
        float distance = (float)this.parent.getWidth() * 0.36f * easedProgress;
        int iconX = (int)((float)this.parent.getX() + (float)this.parent.getWidth() / 2.0f + (float)this.dx * distance) - s;
        int iconY = (int)((float)this.parent.getY() + (float)this.parent.getHeight() / 2.0f + (float)this.dy * distance) - s;
        this.setRectangle(s * 2, s * 2, iconX, iconY);
    }

    @Override
    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        ResourceLocation texture = Minecraft.getInstance().level == null ? AbstractSelectionList.MENU_LIST_BACKGROUND : AbstractSelectionList.INWORLD_MENU_LIST_BACKGROUND;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texture, this.getX(), this.getY(), (float)this.getRight(), (float)this.getBottom(), this.getWidth(), this.getHeight(), 32, 32);
        super.renderWidget(guiGraphics, this.isAnimFinishing ? mouseX : 0, this.isAnimFinishing ? mouseY : 0, partialTick);
    }

    @Override
    protected void renderHover(GuiGraphics guiGraphics) {
        guiGraphics.fill(this.getX(), this.getY(), this.getRight(), this.getBottom(), ARGB.color((int)128, (int)66, (int)66, (int)66));
    }
}

