/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.main.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.mojang.blaze3d.platform.InputConstants;
import io.github.kosmx.emotes.main.config.ClientConfig;
import io.github.kosmx.emotes.server.config.ConfigSerializer;
import it.unimi.dsi.fastutil.Pair;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.UUID;

public class ClientConfigSerializer
extends ConfigSerializer<ClientConfig> {
    public ClientConfigSerializer() {
        super(ClientConfig::new);
    }

    @Override
    public ClientConfig deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        ClientConfig config = (ClientConfig)super.deserialize(json, typeOfT, context);
        this.clientDeserialize(json.getAsJsonObject(), config);
        return config;
    }

    public JsonElement serialize(ClientConfig config, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject node = super.serialize(config, typeOfSrc, context).getAsJsonObject();
        this.clientSerialize(config, node);
        return node;
    }

    private void clientDeserialize(JsonObject node, ClientConfig config) {
        if (node.has("fastmenu")) {
            this.fastMenuDeserializer(node.get("fastmenu").getAsJsonObject(), config);
        }
        if (node.has("keys")) {
            this.keyBindsDeserializer(node.get("keys"), config);
        }
    }

    private void fastMenuDeserializer(JsonObject node, ClientConfig config) {
        for (int j = 0; j < config.fastMenuEmotes.length; ++j) {
            if (!node.has(Integer.toString(j))) continue;
            JsonElement subNode = node.get(Integer.toString(j));
            if (subNode.isJsonObject()) {
                for (int i = 0; i != 8; ++i) {
                    if (!node.get(Integer.toString(j)).getAsJsonObject().has(Integer.toString(i))) continue;
                    config.fastMenuEmotes[j][i] = ClientConfigSerializer.getEmoteID(node.get(Integer.toString(j)).getAsJsonObject().get(Integer.toString(i)));
                }
                continue;
            }
            config.fastMenuEmotes[0][j] = ClientConfigSerializer.getEmoteID(node.get(Integer.toString(j)));
        }
    }

    private void keyBindsDeserializer(JsonElement node, ClientConfig config) {
        if (config.configVersion < 4) {
            this.oldKeyBindsSerializer(node.getAsJsonArray(), config);
        } else {
            for (Map.Entry element : node.getAsJsonObject().entrySet()) {
                String str = ((JsonElement)element.getValue()).getAsString();
                config.emoteKeyMap.put(UUID.fromString((String)element.getKey()), InputConstants.getKey((String)str));
            }
        }
    }

    private void oldKeyBindsSerializer(JsonArray node, ClientConfig config) {
        for (JsonElement jsonElement : node) {
            JsonObject n = jsonElement.getAsJsonObject();
            String str = n.get("key").getAsString();
            config.emoteKeyMap.add((Pair<UUID, InputConstants.Key>)Pair.of((Object)ClientConfigSerializer.getEmoteID(n.get("id")), (Object)InputConstants.getKey((String)str)));
        }
    }

    private void clientSerialize(ClientConfig config, JsonObject node) {
        node.add("fastmenu", (JsonElement)this.fastMenuSerializer(config));
        node.add("keys", (JsonElement)this.keyBindsSerializer(config));
    }

    private JsonObject fastMenuSerializer(ClientConfig config) {
        JsonObject node = new JsonObject();
        for (int j = 0; j < config.fastMenuEmotes.length; ++j) {
            if (config.fastMenuEmotes[j] == null) continue;
            JsonObject subNode = new JsonObject();
            for (int i = 0; i != 8; ++i) {
                if (config.fastMenuEmotes[j][i] == null) continue;
                subNode.addProperty(Integer.toString(i), config.fastMenuEmotes[j][i].toString());
                node.add(Integer.toString(j), (JsonElement)subNode);
            }
        }
        return node;
    }

    private JsonObject keyBindsSerializer(ClientConfig config) {
        JsonObject array = new JsonObject();
        for (Pair<UUID, InputConstants.Key> pair : config.emoteKeyMap) {
            array.addProperty(((UUID)pair.left()).toString(), ((InputConstants.Key)pair.right()).getName());
        }
        return array;
    }

    public static UUID getEmoteID(JsonElement element) {
        try {
            return UUID.fromString(element.getAsString());
        }
        catch (Exception e) {
            return new UUID(0L, 0L);
        }
    }
}

