/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.mc.services;

import io.github.kosmx.emotes.api.services.IEmotecraftService;
import io.github.kosmx.emotes.common.tools.ServiceLoaderUtil;
import io.github.kosmx.emotes.mc.services.impl.VanillaPermissionService;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import org.jetbrains.annotations.NotNull;

public interface IPermissionService
extends IEmotecraftService {
    public static final IPermissionService INSTANCE = ServiceLoaderUtil.loadService(IPermissionService.class, VanillaPermissionService::new);

    default public Predicate<CommandSourceStack> require(@NotNull String permission, int defaultValue) {
        Objects.requireNonNull(permission, "permission");
        return player -> this.check((CommandSourceStack)player, permission, defaultValue);
    }

    default public boolean check(@NotNull CommandSourceStack source, @NotNull String permission, int defaultValue) {
        return this.getPermissionValue(source, permission).orElseGet(() -> source.hasPermission(defaultValue));
    }

    public Optional<Boolean> getPermissionValue(@NotNull CommandSourceStack var1, @NotNull String var2);
}

