/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.server.serializer;

import com.zigythebird.playeranimcore.animation.Animation;
import com.zigythebird.playeranimcore.animation.ExtraAnimationData;
import io.github.kosmx.emotes.api.proxy.AbstractNetworkInstance;
import io.github.kosmx.emotes.server.serializer.EmoteSerializer;
import io.github.kosmx.emotes.server.serializer.UniversalEmoteSerializer;
import io.github.kosmx.emotes.server.serializer.type.ISerializer;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.regex.Pattern;
import net.raphimc.noteblocklib.NoteBlockLib;
import net.raphimc.noteblocklib.model.Song;

public class EmoteWriter {
    private static final Pattern INVALID_FILENAME_CHARS = Pattern.compile("[\\\\/:*?\"<>|]");

    public static void writeAnimationInBestFormat(Animation animation, Path exportDir) throws Exception {
        EmoteWriter.writeAnimationInFormat(animation, exportDir, UniversalEmoteSerializer.findBestSerializer());
    }

    public static void writeAnimationInFormat(Animation animation, Path exportDir, ISerializer format) throws Exception {
        Path file = EmoteWriter.createFileName(animation, exportDir, format.getExtension());
        try (OutputStream stream = Files.newOutputStream(file, new OpenOption[0]);){
            format.write(animation, stream, file.getFileName().toString());
        }
        if (format.onlyEmoteFile()) {
            Object iconPath;
            String fileName = EmoteSerializer.getBaseName(file.getFileName().toString());
            Object object = animation.data().getRaw("iconData");
            if (object instanceof ByteBuffer) {
                ByteBuffer iconData = (ByteBuffer)object;
                iconPath = exportDir.resolve(fileName + ".png");
                if (Files.exists((Path)iconPath, new LinkOption[0])) {
                    throw new FileAlreadyExistsException(iconPath.toString());
                }
                try (OutputStream iconStream = Files.newOutputStream((Path)iconPath, new OpenOption[0]);){
                    iconStream.write(AbstractNetworkInstance.safeGetBytesFromBuffer(iconData));
                    iconStream.flush();
                }
            }
            if ((iconPath = animation.data().getRaw("song")) instanceof Song) {
                Song song = (Song)iconPath;
                Path songPath = exportDir.resolve(fileName + ".nbs");
                if (Files.exists(songPath, new LinkOption[0])) {
                    throw new FileAlreadyExistsException(songPath.toString());
                }
                NoteBlockLib.writeSong((Song)song, (Path)songPath);
            }
        }
    }

    private static Path createFileName(Animation emote, Path originPath, String ext) {
        String fileName = emote.data().get("fileName").map(EmoteSerializer::getBaseName).orElseGet(() -> ((ExtraAnimationData)emote.data()).name());
        if (fileName == null) {
            throw new NullPointerException();
        }
        String baseName = INVALID_FILENAME_CHARS.matcher(fileName).replaceAll("#");
        Path file = originPath.resolve(baseName + "." + ext);
        int i = 1;
        while (Files.exists(file, new LinkOption[0])) {
            file = originPath.resolve(baseName + "_" + i++ + "." + ext);
        }
        return file;
    }
}

