/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.advquarry;

import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machine.Area;
import com.yogpc.qp.machine.CombinedBlockEntityTicker;
import com.yogpc.qp.machine.GeneralScreenHandler;
import com.yogpc.qp.machine.MachineStorage;
import com.yogpc.qp.machine.PowerEntity;
import com.yogpc.qp.machine.QpBlock;
import com.yogpc.qp.machine.QpBlockItem;
import com.yogpc.qp.machine.QpBlockProperty;
import com.yogpc.qp.machine.QpEntityBlock;
import com.yogpc.qp.machine.advquarry.AdvQuarryContainer;
import com.yogpc.qp.machine.advquarry.AdvQuarryEntity;
import com.yogpc.qp.machine.advquarry.AdvQuarryInitialAskMessage;
import com.yogpc.qp.machine.advquarry.AdvQuarryItem;
import com.yogpc.qp.machine.advquarry.AdvQuarryState;
import com.yogpc.qp.machine.marker.QuarryMarker;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class AdvQuarryBlock
extends QpEntityBlock {
    public static final String NAME = "adv_quarry";

    public AdvQuarryBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).pushReaction(PushReaction.BLOCK).strength(1.5f, 10.0f).sound(SoundType.STONE), NAME, (Function<? super QpBlock, ? extends QpBlockItem>)((Function<QpBlock, QpBlockItem>)AdvQuarryItem::new));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)QpBlockProperty.WORKING, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH));
    }

    @Override
    protected QpBlock createBlock(BlockBehaviour.Properties properties) {
        return new AdvQuarryBlock();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{QpBlockProperty.WORKING, BlockStateProperties.FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction facing = ctx.getPlayer() == null ? Direction.NORTH : ctx.getPlayer().getDirection().getOpposite();
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)facing);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level.isClientSide) {
            return null;
        }
        return AdvQuarryBlock.createTickerHelper(blockEntityType, this.getBlockEntityType().orElse(null), CombinedBlockEntityTicker.of(this, level, PowerEntity.logTicker(), AdvQuarryEntity::serverTick, MachineStorage.pushItemTicker(), MachineStorage.pushFluidTicker()));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        AdvQuarryEntity entity = this.getBlockEntityType().map(t -> (AdvQuarryEntity)t.getBlockEntity((BlockGetter)level, pos)).orElse(null);
        if (entity != null) {
            if (!level.isClientSide()) {
                if (entity.enabled) {
                    PlatformAccess.getAccess().openGui((ServerPlayer)player, new GeneralScreenHandler<AdvQuarryContainer>(entity, AdvQuarryContainer::new));
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"quarryplus.chat.disable_message", (Object[])new Object[]{this.getName()}), true);
                }
            }
            return InteractionResult.SUCCESS_SERVER;
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AdvQuarryEntity) {
            AdvQuarryEntity quarry = (AdvQuarryEntity)blockEntity;
            if (!level.isClientSide) {
                quarry.updateMaxEnergyWithEnchantment(level);
                Direction facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
                QuarryMarker.Link markerLink = Stream.of(facing.getOpposite(), facing.getCounterClockWise(), facing.getClockWise()).map(arg_0 -> ((BlockPos)pos).relative(arg_0)).map(arg_0 -> ((Level)level).getBlockEntity(arg_0)).filter(QuarryMarker.class::isInstance).map(QuarryMarker.class::cast).flatMap(m -> m.getLink().stream()).findAny().orElseGet(() -> new QuarryMarker.StaticLink(AdvQuarryBlock.createDefaultArea(pos, facing, 0)));
                Area area = Area.assumeY(markerLink.area());
                if (!area.quarryDigPosIterator(pos.getY()).hasNext()) {
                    QuarryPlus.LOGGER.warn("The area for machine({}) doesn't have enough space for work. Area: {}", (Object)pos.toShortString(), (Object)area);
                    if (placer instanceof Player) {
                        Player p = (Player)placer;
                        String text = "This machine doesn't have enough space for work";
                        p.displayClientMessage((Component)Component.literal((String)text).withStyle(ChatFormatting.RED), false);
                    }
                    return;
                }
                quarry.setArea(area);
                markerLink.drops().forEach(quarry.storage::addItem);
                markerLink.remove(level);
                if (placer instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)placer;
                    quarry.workConfig = quarry.workConfig.noAutoStartConfig();
                    PlatformAccess.getAccess().packetHandler().sendToClientPlayer(new AdvQuarryInitialAskMessage(quarry), serverPlayer);
                }
                quarry.setState(AdvQuarryState.WAITING, state);
            }
        }
    }

    protected void affectNeighborsAfterRemoval(BlockState state, ServerLevel level, BlockPos pos, boolean isMoving) {
        super.affectNeighborsAfterRemoval(state, level, pos, isMoving);
        if (level.getBlockEntity(pos) instanceof AdvQuarryEntity) {
            level.updateNeighbourForOutputSignal(pos, state.getBlock());
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.literal((String)"Experimental"));
    }

    @NotNull
    @VisibleForTesting
    static Area createDefaultArea(BlockPos pos, Direction quarryBehind, int limit) {
        int maxZ;
        int minZ;
        int maxX;
        int minX;
        ChunkPos chunkPos = new ChunkPos(pos);
        if (0 < limit && limit < 16) {
            if (pos.getX() - limit / 2 < chunkPos.getMinBlockX()) {
                minX = chunkPos.getMinBlockX();
                maxX = minX + limit - 1;
            } else if (pos.getX() + limit / 2 > chunkPos.getMaxBlockX()) {
                maxX = chunkPos.getMaxBlockX();
                minX = maxX - limit + 1;
            } else {
                minX = pos.getX() - limit / 2;
                maxX = minX + limit - 1;
            }
            if (pos.getZ() - limit / 2 < chunkPos.getMinBlockZ()) {
                minZ = chunkPos.getMinBlockZ();
                maxZ = minZ + limit - 1;
            } else if (pos.getZ() + limit / 2 > chunkPos.getMaxBlockZ()) {
                maxZ = chunkPos.getMaxBlockZ();
                minZ = maxZ - limit + 1;
            } else {
                minZ = pos.getZ() - limit / 2;
                maxZ = minZ + limit - 1;
            }
        } else {
            minX = chunkPos.getMinBlockX();
            maxX = chunkPos.getMaxBlockX();
            minZ = chunkPos.getMinBlockZ();
            maxZ = chunkPos.getMaxBlockZ();
        }
        return new Area(minX - 1, pos.getY(), minZ - 1, maxX + 1, pos.getY() + 4, maxZ + 1, quarryBehind);
    }

    @Override
    protected boolean shouldCloneItemHasData() {
        return true;
    }
}

