/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.marker;

import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.machine.marker.ChunkMarkerEntity;
import com.yogpc.qp.machine.marker.ChunkMarkerMessage;
import com.yogpc.qp.machine.marker.MarkerContainer;
import com.yogpc.qp.machine.misc.IndexedButton;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public final class ChunkMarkerScreen
extends AbstractContainerScreen<MarkerContainer>
implements Button.OnPress {
    private static final ResourceLocation LOCATION = ResourceLocation.fromNamespaceAndPath((String)"quarryplus", (String)"textures/gui/marker.png");
    private static final int CHUNK = 16;
    private final ChunkMarkerEntity marker;
    private static final int BUTTON_WIDTH = 44;

    public ChunkMarkerScreen(MarkerContainer menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.marker = (ChunkMarkerEntity)playerInventory.player.level().getBlockEntity(menu.pos);
        this.imageWidth = 217;
        this.imageHeight = 188;
        this.inventoryLabelY = this.imageHeight - 96 + 2;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.render(graphics, mouseX, mouseY, delta);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
        int pX = this.leftPos;
        int pY = this.topPos;
        graphics.blit(RenderPipelines.GUI_TEXTURED, LOCATION, pX, pY, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        super.renderLabels(graphics, mouseX, mouseY);
        graphics.drawString(this.font, "Size", (this.imageWidth - this.font.width("Size")) / 2, 6, ARGB.opaque((int)0x404040), false);
        String sizeText = Integer.toString(this.marker.size / 16);
        graphics.drawString(this.font, sizeText, (this.imageWidth - this.font.width(sizeText)) / 2, 38, ARGB.opaque((int)0x404040), false);
        String yMaxText = Integer.toString(this.marker.maxY);
        String yMinText = Integer.toString(this.marker.minY);
        graphics.drawString(this.font, yMaxText, (this.imageWidth - this.font.width(yMaxText)) / 2 + 10 + 44, 38, ARGB.opaque((int)0x404040), false);
        graphics.drawString(this.font, yMinText, (this.imageWidth - this.font.width(yMinText)) / 2 - 10 - 44, 38, ARGB.opaque((int)0x404040), false);
    }

    public void init() {
        super.init();
        int tp = 15;
        int middle = this.leftPos + this.imageWidth / 2;
        AtomicInteger id = new AtomicInteger(0);
        this.addRenderableWidget((GuiEventListener)new IndexedButton(id.getAndIncrement(), middle - 22, this.topPos + 15, 44, 20, (Component)Component.literal((String)"+"), this));
        this.addRenderableWidget((GuiEventListener)new IndexedButton(id.getAndIncrement(), middle - 22, this.topPos + 15 + 33, 44, 20, (Component)Component.literal((String)"-"), this));
        this.addRenderableWidget((GuiEventListener)new IndexedButton(id.getAndIncrement(), middle + 22 + 10, this.topPos + 15, 44, 20, (Component)Component.literal((String)"Top+"), this));
        this.addRenderableWidget((GuiEventListener)new IndexedButton(id.getAndIncrement(), middle + 22 + 10, this.topPos + 15 + 33, 44, 20, (Component)Component.literal((String)"Top-"), this));
        this.addRenderableWidget((GuiEventListener)new IndexedButton(id.getAndIncrement(), middle - 22 - 10 - 44, this.topPos + 15, 44, 20, (Component)Component.literal((String)"Bottom+"), this));
        this.addRenderableWidget((GuiEventListener)new IndexedButton(id.getAndIncrement(), middle - 22 - 10 - 44, this.topPos + 15 + 33, 44, 20, (Component)Component.literal((String)"Bottom-"), this));
    }

    public void onPress(Button button) {
        int size = this.marker.size;
        int yMin = this.marker.minY;
        int yMax = this.marker.maxY;
        int n = Screen.hasShiftDown() ? 16 : (Screen.hasControlDown() ? 4 : 1);
        if (button instanceof IndexedButton) {
            IndexedButton indexedButton = (IndexedButton)button;
            switch (indexedButton.getIndex()) {
                case 0: {
                    size = this.marker.size + 16;
                    break;
                }
                case 1: {
                    if (this.marker.size > 16) {
                        size = this.marker.size - 16;
                        break;
                    }
                    size = this.marker.size;
                    break;
                }
                case 2: {
                    yMax = this.marker.maxY + n;
                    break;
                }
                case 3: {
                    yMax = Math.max(this.marker.maxY - n, yMin);
                    break;
                }
                case 4: {
                    yMin = Math.min(this.marker.minY + n, yMax);
                    break;
                }
                case 5: {
                    yMin = this.marker.minY - n;
                }
            }
        }
        this.marker.size = size;
        this.marker.minY = yMin;
        this.marker.maxY = yMax;
        PlatformAccess.getAccess().packetHandler().sendToServer(new ChunkMarkerMessage(this.marker));
    }
}

