/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.marker;

import com.yogpc.qp.machine.QpBlock;
import com.yogpc.qp.machine.QpBlockItem;
import com.yogpc.qp.machine.QpEntityBlock;
import com.yogpc.qp.machine.marker.NormalMarkerEntity;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class NormalMarkerBlock
extends QpEntityBlock {
    private static final VoxelShape STANDING_Shape = Shapes.box((double)0.35, (double)0.0, (double)0.35, (double)0.65, (double)0.65, (double)0.65);
    private static final VoxelShape DOWN_Shape = Shapes.box((double)0.35, (double)0.35, (double)0.35, (double)0.65, (double)1.0, (double)0.65);
    private static final VoxelShape NORTH_Shape = Shapes.box((double)0.35, (double)0.35, (double)0.35, (double)0.65, (double)0.65, (double)1.0);
    private static final VoxelShape SOUTH_Shape = Shapes.box((double)0.35, (double)0.35, (double)0.0, (double)0.65, (double)0.65, (double)0.65);
    private static final VoxelShape WEST_Shape = Shapes.box((double)0.35, (double)0.35, (double)0.35, (double)1.0, (double)0.65, (double)0.65);
    private static final VoxelShape EAST_Shape = Shapes.box((double)0.0, (double)0.35, (double)0.35, (double)0.65, (double)0.65, (double)0.65);
    public static final String NAME = "marker";

    public NormalMarkerBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.NONE).pushReaction(PushReaction.DESTROY).instabreak().lightLevel(value -> 7).noCollission(), NAME, (Function<? super QpBlock, ? extends QpBlockItem>)((Function<QpBlock, QpBlockItem>)b -> new QpBlockItem((QpBlock)b, new Item.Properties())));
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.UP));
    }

    @Override
    protected QpBlock createBlock(BlockBehaviour.Properties properties) {
        return new NormalMarkerBlock();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)ctx.getClickedFace());
    }

    public boolean skipRendering(BlockState state, BlockState stateFrom, Direction direction) {
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)BlockStateProperties.FACING)) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> STANDING_Shape;
            case Direction.DOWN -> DOWN_Shape;
            case Direction.EAST -> EAST_Shape;
            case Direction.WEST -> WEST_Shape;
            case Direction.NORTH -> NORTH_Shape;
            case Direction.SOUTH -> SOUTH_Shape;
        };
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)BlockStateProperties.FACING);
        BlockPos blockPos = pos.relative(direction.getOpposite());
        BlockState blockState = world.getBlockState(blockPos);
        return blockState.isFaceSturdy((BlockGetter)world, blockPos, direction);
    }

    public BlockState updateShape(BlockState state, LevelReader levelReader, ScheduledTickAccess scheduledTickAccess, BlockPos currentPos, Direction direction, BlockPos blockPos2, BlockState blockState2, RandomSource randomSource) {
        return state.canSurvive(levelReader, currentPos) ? super.updateShape(state, levelReader, scheduledTickAccess, currentPos, direction, blockPos2, blockState2, randomSource) : Blocks.AIR.defaultBlockState();
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof NormalMarkerEntity) {
            NormalMarkerEntity marker = (NormalMarkerEntity)blockEntity;
            if (!level.isClientSide()) {
                marker.tryConnect(c -> player.displayClientMessage(c, false));
            }
            return InteractionResult.SUCCESS_SERVER;
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }
}

