/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.misc;

import com.yogpc.qp.machine.CombinedBlockEntityTicker;
import com.yogpc.qp.machine.QpBlock;
import com.yogpc.qp.machine.QpBlockItem;
import com.yogpc.qp.machine.QpEntityBlock;
import com.yogpc.qp.machine.misc.GeneratorEntity;
import java.util.List;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class GeneratorBlock
extends QpEntityBlock {
    public static final String NAME = "creative_generator";
    static final int LEVEL_MAX = BlockStateProperties.LEVEL.getPossibleValues().stream().max(Integer::compareTo).orElse(0);
    static final long[] ENERGY = IntStream.rangeClosed(0, LEVEL_MAX).mapToLong(i -> (long)(Math.pow(2.213465466013801, i) * 1.0E9)).toArray();

    public GeneratorBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).pushReaction(PushReaction.BLOCK).strength(1.0f, 1.0f).sound(SoundType.STONE), NAME, (Function<? super QpBlock, ? extends QpBlockItem>)((Function<QpBlock, QpBlockItem>)block -> new QpBlockItem((QpBlock)block, new Item.Properties().fireResistant())));
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.LEVEL, (Comparable)Integer.valueOf(LEVEL_MAX)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.LEVEL});
    }

    @Override
    protected QpBlock createBlock(BlockBehaviour.Properties properties) {
        return new GeneratorBlock();
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.literal((String)"Works only for Quarry"));
        tooltipComponents.add((Component)Component.literal((String)"Only for debug purposes").withStyle(ChatFormatting.RED));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level.isClientSide()) {
            return null;
        }
        return GeneratorBlock.createTickerHelper(blockEntityType, this.getBlockEntityType().orElse(null), CombinedBlockEntityTicker.of(this, level, GeneratorEntity::serverTick));
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            int pre = (Integer)state.getValue((Property)BlockStateProperties.LEVEL);
            int newValue = (player.isShiftKeyDown() ? pre - 1 : pre + 1) & 0xF;
            level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.LEVEL, (Comparable)Integer.valueOf(newValue)), 3);
            player.displayClientMessage((Component)Component.literal((String)"Change generator mode to %d(%d FE)".formatted(newValue, ENERGY[newValue] / 1000000000L)), false);
        }
        return InteractionResult.SUCCESS;
    }
}

