/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.misc;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.QuarryPlus;
import java.lang.runtime.SwitchBootstraps;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public sealed interface QuarryChunkLoader {
    public static final Marker MARKER = MarkerFactory.getMarker((String)QuarryChunkLoader.class.getSimpleName());
    public static final Codec<QuarryChunkLoader> CODEC = Codec.STRING.dispatch(QuarryChunkLoader::type, QuarryChunkLoader::codec);

    public static boolean isChunkLoaded(ServerLevel level, BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        boolean result = level.getForceLoadedChunks().contains(chunkPos.toLong());
        QuarryPlus.LOGGER.info(MARKER, "Check state of chunk loading x={}, z={}, loaded={}", new Object[]{chunkPos.x, chunkPos.z, result});
        return result;
    }

    public static QuarryChunkLoader of(ServerLevel level, BlockPos pos) {
        if (!PlatformAccess.config().enableChunkLoader()) {
            return None.INSTANCE;
        }
        if (QuarryChunkLoader.isChunkLoaded(level, pos)) {
            return None.INSTANCE;
        }
        return new Load(pos);
    }

    public void makeChunkLoaded(ServerLevel var1);

    public void makeChunkUnLoaded(ServerLevel var1);

    public String type();

    public static MapCodec<? extends QuarryChunkLoader> codec(String type) {
        String string = type;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"None", "Load"}, (Object)string, n)) {
            case 0 -> None.CODEC;
            case 1 -> Load.CODEC;
            default -> throw new IllegalStateException("Unexpected value: " + type);
        };
    }

    public static enum None implements QuarryChunkLoader
    {
        INSTANCE;

        private static final MapCodec<None> CODEC;

        @Override
        public void makeChunkLoaded(ServerLevel level) {
        }

        @Override
        public void makeChunkUnLoaded(ServerLevel level) {
        }

        @Override
        public String type() {
            return this.getDeclaringClass().getSimpleName();
        }

        static {
            CODEC = MapCodec.unit((Object)INSTANCE);
        }
    }

    public record Load(BlockPos pos) implements QuarryChunkLoader
    {
        private static final MapCodec<Load> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RecordCodecBuilder.of(Load::pos, (String)"pos", (Codec)BlockPos.CODEC)).apply((Applicative)instance, Load::new));

        @Override
        public void makeChunkLoaded(ServerLevel level) {
            ChunkPos chunkPos = new ChunkPos(this.pos);
            level.setChunkForced(chunkPos.x, chunkPos.z, true);
            QuarryPlus.LOGGER.info(MARKER, "Force chunk load at x={}, z={}", (Object)chunkPos.x, (Object)chunkPos.z);
        }

        @Override
        public void makeChunkUnLoaded(ServerLevel level) {
            ChunkPos chunkPos = new ChunkPos(this.pos);
            level.setChunkForced(chunkPos.x, chunkPos.z, false);
            QuarryPlus.LOGGER.info(MARKER, "Remove chunk loading at x={}, z={}", (Object)chunkPos.x, (Object)chunkPos.z);
        }

        @Override
        public String type() {
            return this.getClass().getSimpleName();
        }
    }
}

