/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.module;

import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.QuarryDataComponents;
import com.yogpc.qp.machine.MachineStorage;
import com.yogpc.qp.machine.misc.SlotContainer;
import com.yogpc.qp.machine.module.FilterModuleItem;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public final class FilterModuleContainer
extends AbstractContainerMenu {
    public static final String NAME = "gui_filter_module";
    public static final String GUI_ID = "quarryplus:gui_filter_module";
    final int containerRows;
    final int allSlots;
    private final ContainerInv container;

    public FilterModuleContainer(int id, Inventory inventory, ItemStack filterModuleItem) {
        super(PlatformAccess.getAccess().registerObjects().filterModuleContainer().get(), id);
        Player player = inventory.player;
        this.container = new ContainerInv(filterModuleItem);
        this.containerRows = FilterModuleItem.getRowsFromStack(filterModuleItem);
        this.allSlots = this.containerRows * 9;
        int i = (this.containerRows - 4) * 18;
        int oneBox = 18;
        for (int j = 0; j < this.containerRows; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new SlotContainer((Container)this.container, k + j * 9, 8 + k * 18, 18 + j * 18));
            }
        }
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.addSlot(new Slot((Container)player.getInventory(), j1 + l * 9 + 9, 8 + j1 * 18, 103 + l * 18 + i));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.addSlot(new NotPickUpSlot((Container)player.getInventory(), i1, 8 + i1 * 18, 161 + i));
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack slotItem = slot.getItem();
            ItemStack copy = slotItem.copy();
            if (index < this.allSlots ? !this.moveItemStackTo(slotItem, this.allSlots, this.slots.size(), true) : !this.moveItemStackTo(slotItem, 0, this.allSlots, false)) {
                return ItemStack.EMPTY;
            }
            if (slotItem.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            return copy;
        }
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void removed(Player player) {
        super.removed(player);
        this.container.stopOpen(player);
    }

    private static class ContainerInv
    extends SimpleContainer {
        private final ItemStack filterModuleItem;

        public ContainerInv(ItemStack filterModuleItem) {
            super(FilterModuleItem.getRowsFromStack(filterModuleItem) * 9);
            this.filterModuleItem = filterModuleItem;
            Optional.ofNullable((List)filterModuleItem.get(QuarryDataComponents.ITEM_KEY_LIST_COMPONENT)).stream().flatMap(Collection::stream).map(itemKey -> itemKey.toStack(1)).forEach(arg_0 -> ((ContainerInv)this).addItem(arg_0));
        }

        public final int getMaxStackSize() {
            return 1;
        }

        public void stopOpen(Player player) {
            super.stopOpen(player);
            if (this.isEmpty()) {
                this.filterModuleItem.remove(QuarryDataComponents.ITEM_KEY_LIST_COMPONENT);
            } else {
                List<MachineStorage.ItemKey> itemKeys = this.getItems().stream().filter(Predicate.not(ItemStack::isEmpty)).map(MachineStorage.ItemKey::of).toList();
                this.filterModuleItem.set(QuarryDataComponents.ITEM_KEY_LIST_COMPONENT, itemKeys);
            }
        }

        public boolean canPlaceItem(int pIndex, ItemStack pStack) {
            return this.countItem(pStack.getItem()) == 0 && !pStack.is(this.filterModuleItem.getItem());
        }
    }

    private static class NotPickUpSlot
    extends Slot {
        public NotPickUpSlot(Container container, int slot, int x, int y) {
            super(container, slot, x, y);
        }

        public boolean mayPickup(Player player) {
            return this.getContainerSlot() != player.getInventory().getSelectedSlot();
        }
    }
}

