/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.module;

import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.machine.misc.SlotContainer;
import com.yogpc.qp.machine.misc.YAccessor;
import com.yogpc.qp.machine.module.ModuleInventory;
import com.yogpc.qp.machine.module.ModuleInventoryHolder;
import com.yogpc.qp.packet.ClientSync;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public final class ModuleContainer
extends AbstractContainerMenu {
    public static final String GUI_ID = "quarryplus:gui_quarry_module";
    @Nullable
    final ModuleInventory moduleInventory;
    @Nullable
    final YAccessor<?> yAccessor;
    private final BlockPos pos;

    public ModuleContainer(int id, Inventory inventory, BlockPos pos) {
        super(PlatformAccess.getAccess().registerObjects().moduleContainer().get(), id);
        this.pos = pos;
        BlockEntity entity = inventory.player.level().getBlockEntity(pos);
        this.moduleInventory = ModuleInventoryHolder.getFromObject(entity).orElse(null);
        this.yAccessor = YAccessor.get(entity);
        int oneBox = 18;
        if (this.moduleInventory != null) {
            for (int i = 0; i < this.moduleInventory.getContainerSize(); ++i) {
                int verticalFix = i < 5 ? i : i - 5;
                int horizontalFix = i / 5;
                this.addSlot(new SlotContainer((Container)this.moduleInventory, i, 44 + verticalFix * 18, 27 + horizontalFix * 18));
            }
        }
        for (int h = 0; h < 3; ++h) {
            for (int v = 0; v < 9; ++v) {
                this.addSlot(new Slot((Container)inventory, v + h * 9 + 9, 8 + v * 18, 84 + h * 18));
            }
        }
        for (int vertical = 0; vertical < 9; ++vertical) {
            this.addSlot(new Slot((Container)inventory, vertical, 8 + vertical * 18, 142));
        }
        if (this.yAccessor != null) {
            ((ClientSync)this.yAccessor.entity()).syncToClient();
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        int allSlots = this.moduleInventory != null ? this.moduleInventory.getContainerSize() : 0;
        Slot slot = this.getSlot(index);
        if (slot.hasItem()) {
            ItemStack remain = slot.getItem();
            ItemStack slotContent = remain.copy();
            if (index < allSlots ? !this.moveItemStackTo(remain, allSlots, 36 + allSlots, true) : !this.moveItemStackTo(remain, 0, allSlots, false)) {
                return ItemStack.EMPTY;
            }
            if (remain.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (remain.getCount() == slotContent.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, remain);
            return slotContent;
        }
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player player) {
        return this.pos.closerToCenterThan((Position)player.position(), 8.0);
    }
}

